/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Device;
import com.android.ddmlib.MultiLineReceiver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GetPropReceiver
extends MultiLineReceiver {
    static final String GETPROP_COMMAND = "getprop";
    private static final Pattern GETPROP_PATTERN = Pattern.compile("^\\[([^]]+)\\]\\:\\s*\\[(.*)\\]$");
    private Device mDevice = null;

    public GetPropReceiver(Device device) {
        this.mDevice = device;
    }

    public void processNewLines(String[] lines) {
        for (String line : lines) {
            Matcher m;
            if (line.length() == 0 || line.startsWith("#") || !(m = GETPROP_PATTERN.matcher(line)).matches()) continue;
            String label = m.group(1);
            String value = m.group(2);
            if (label.length() <= 0) continue;
            this.mDevice.addProperty(label, value);
        }
    }

    public boolean isCancelled() {
        return false;
    }

    public void done() {
        this.mDevice.update(4);
    }
}

