/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.minlog.Log;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class BigIntegerSerializer
extends Serializer {
    public BigInteger readObjectData(ByteBuffer byteBuffer, Class clazz) {
        int n = IntSerializer.get(byteBuffer, true);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray, 0, n);
        BigInteger bigInteger = new BigInteger(byArray);
        if (Log.TRACE) {
            Log.trace("kryo", "Read BigInteger: " + bigInteger);
        }
        return bigInteger;
    }

    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        BigInteger bigInteger = (BigInteger)object;
        byte[] byArray = bigInteger.toByteArray();
        IntSerializer.put(byteBuffer, byArray.length, true);
        byteBuffer.put(byArray);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote BigInteger: " + bigInteger);
        }
    }
}

