/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class ByteSerializer
extends Serializer {
    public Byte readObjectData(ByteBuffer byteBuffer, Class clazz) {
        byte by = byteBuffer.get();
        if (Log.TRACE) {
            Log.trace("kryo", "Read byte: " + by);
        }
        return by;
    }

    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        byteBuffer.put((Byte)object);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote byte: " + object);
        }
    }

    public static void putUnsigned(ByteBuffer byteBuffer, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("value cannot be less than zero: " + n);
        }
        byteBuffer.put((byte)n);
    }

    public static int getUnsigned(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by < 0) {
            return by + 256;
        }
        return by;
    }
}

