/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class FloatSerializer
extends Serializer {
    private final float precision;
    private final boolean optimizePositive;

    public FloatSerializer() {
        this.precision = 0.0f;
        this.optimizePositive = false;
    }

    public FloatSerializer(float f, boolean bl) {
        this.precision = f;
        this.optimizePositive = bl;
    }

    public Float readObjectData(ByteBuffer byteBuffer, Class clazz) {
        float f = this.precision == 0.0f ? byteBuffer.getFloat() : (float)IntSerializer.get(byteBuffer, this.optimizePositive) / this.precision;
        if (Log.TRACE) {
            Log.trace("kryo", "Read float: " + f);
        }
        return Float.valueOf(f);
    }

    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        if (this.precision == 0.0f) {
            byteBuffer.putFloat(((Float)object).floatValue());
        } else {
            IntSerializer.put(byteBuffer, (int)(((Float)object).floatValue() * this.precision), this.optimizePositive);
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote float: " + object);
        }
    }
}

