/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Context;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.serialize.FieldSerializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryo.util.IntHashMap;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceFieldSerializer
extends FieldSerializer {
    public ReferenceFieldSerializer(Kryo kryo, Class clazz) {
        super(kryo, clazz);
    }

    @Override
    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        Integer n;
        Context context = Kryo.getContext();
        References references = (References)context.getTemp("references");
        if (references == null) {
            references = (References)context.get("references");
            if (references == null) {
                references = new References();
                context.put("references", references);
            } else {
                references.reset();
            }
            context.putTemp("references", references);
        }
        if ((n = references.objectToReference.get(object)) != null) {
            IntSerializer.put(byteBuffer, n, true);
            if (Log.TRACE) {
                Log.trace("kryo", "Wrote object reference " + n + ": " + object);
            }
            return;
        }
        byteBuffer.put((byte)0);
        ++references.referenceCount;
        references.objectToReference.put(object, references.referenceCount);
        super.writeObjectData(byteBuffer, object);
    }

    @Override
    public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> clazz) {
        int n;
        Context context = Kryo.getContext();
        References references = (References)context.getTemp("references");
        if (references == null) {
            references = (References)context.get("references");
            if (references == null) {
                references = new References();
                context.put("references", references);
            } else {
                references.reset();
            }
            context.putTemp("references", references);
        }
        if ((n = IntSerializer.get(byteBuffer, true)) != 0) {
            Object t = references.referenceToObject.get(n);
            if (t == null) {
                throw new SerializationException("Invalid object reference: " + n);
            }
            if (Log.TRACE) {
                Log.trace("kryo", "Read object reference " + n + ": " + t);
            }
            return t;
        }
        T t = this.newInstance(this.kryo, clazz);
        ++references.referenceCount;
        references.referenceToObject.put(references.referenceCount, t);
        return super.readObjectData(t, byteBuffer, clazz);
    }

    static class References {
        public IdentityHashMap<Object, Integer> objectToReference = new IdentityHashMap();
        public IntHashMap referenceToObject = new IntHashMap();
        public int referenceCount = 1;

        References() {
        }

        public void reset() {
            this.objectToReference.clear();
            this.referenceToObject.clear();
            this.referenceCount = 1;
        }
    }
}

