/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHashMap<T> {
    private Entry[] table;
    private float loadFactor;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;

    public IntHashMap() {
        this(16, 0.75f);
    }

    public IntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntHashMap(int n, float f) {
        if (n > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    public boolean containsValue(Object object) {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(int n) {
        int n2 = n & this.mask;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.key == n) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public T get(int n) {
        int n2 = n & this.mask;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.key == n) {
                return (T)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public T put(int n, T t) {
        int n2 = n & this.mask;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.key == n) {
                Object object = entry.value;
                entry.value = t;
                return (T)object;
            }
            entry = entry.next;
        }
        this.table[n2] = new Entry(n, t, this.table[n2]);
        if (this.size++ >= this.threshold) {
            int n3 = 2 * this.capacity;
            Entry[] entryArray = new Entry[n3];
            Entry[] entryArray2 = this.table;
            int n4 = n3 - 1;
            for (int i = 0; i < entryArray2.length; ++i) {
                Entry entry2;
                Entry entry3 = entryArray2[i];
                if (entry3 == null) continue;
                entryArray2[i] = null;
                do {
                    entry2 = entry3.next;
                    n2 = entry3.key & n4;
                    entry3.next = entryArray[n2];
                    entryArray[n2] = entry3;
                } while ((entry3 = entry2) != null);
            }
            this.table = entryArray;
            this.capacity = n3;
            this.threshold = (int)((float)n3 * this.loadFactor);
            this.mask = this.capacity - 1;
        }
        return null;
    }

    public T remove(int n) {
        Entry entry;
        int n2 = n & this.mask;
        Entry entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == n) {
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return (T)entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.size = 0;
    }

    static class Entry {
        final int key;
        Object value;
        Entry next;

        Entry(int n, Object object, Entry entry) {
            this.key = n;
            this.value = object;
            this.next = entry;
        }
    }
}

