/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

public class LongToIntHashMap {
    private Entry[] table;
    private float loadFactor;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;

    public LongToIntHashMap() {
        this(16, 0.75f);
    }

    public LongToIntHashMap(int n) {
        this(n, 0.75f);
    }

    public LongToIntHashMap(int n, float f) {
        if (n > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    public boolean containsValue(int n) {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.value == n) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(long l) {
        int n = (int)l & this.mask;
        Entry entry = this.table[n];
        while (entry != null) {
            if (entry.key == l) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int get(long l) {
        int n = (int)l & this.mask;
        Entry entry = this.table[n];
        while (entry != null) {
            if (entry.key == l) {
                return entry.value;
            }
            entry = entry.next;
        }
        return 0;
    }

    public int put(long l, int n) {
        int n2 = (int)l & this.mask;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.key == l) {
                int n3 = entry.value;
                entry.value = n;
                return n3;
            }
            entry = entry.next;
        }
        this.table[n2] = new Entry(l, n, this.table[n2]);
        if (this.size++ >= this.threshold) {
            int n4 = 2 * this.capacity;
            Entry[] entryArray = new Entry[n4];
            Entry[] entryArray2 = this.table;
            int n5 = n4 - 1;
            for (int i = 0; i < entryArray2.length; ++i) {
                Entry entry2;
                Entry entry3 = entryArray2[i];
                if (entry3 == null) continue;
                entryArray2[i] = null;
                do {
                    entry2 = entry3.next;
                    n2 = (int)entry3.key & n5;
                    entry3.next = entryArray[n2];
                    entryArray[n2] = entry3;
                } while ((entry3 = entry2) != null);
            }
            this.table = entryArray;
            this.capacity = n4;
            this.threshold = (int)((float)n4 * this.loadFactor);
            this.mask = this.capacity - 1;
        }
        return 0;
    }

    public int remove(long l) {
        Entry entry;
        int n = (int)l & this.mask;
        Entry entry2 = entry = this.table[n];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == l) {
                --this.size;
                if (entry == entry2) {
                    this.table[n] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.size = 0;
    }

    static class Entry {
        final long key;
        int value;
        Entry next;

        Entry(long l, int n, Entry entry) {
            this.key = l;
            this.value = n;
            this.next = entry;
        }
    }
}

