/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortHashMap<T> {
    private Entry[] table;
    private float loadFactor;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;

    public ShortHashMap() {
        this(16, 0.75f);
    }

    public ShortHashMap(int n) {
        this(n, 0.75f);
    }

    public ShortHashMap(int n, float f) {
        if (n > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    public boolean containsValue(Object object) {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(short s) {
        int n = s & this.mask;
        Entry entry = this.table[n];
        while (entry != null) {
            if (entry.key == s) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public T get(short s) {
        int n = s & this.mask;
        Entry entry = this.table[n];
        while (entry != null) {
            if (entry.key == s) {
                return (T)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public T put(short s, T t) {
        int n = s & this.mask;
        Entry entry = this.table[n];
        while (entry != null) {
            if (entry.key == s) {
                Object object = entry.value;
                entry.value = t;
                return (T)object;
            }
            entry = entry.next;
        }
        this.table[n] = new Entry(s, t, this.table[n]);
        if (this.size++ >= this.threshold) {
            int n2 = 2 * this.capacity;
            Entry[] entryArray = new Entry[n2];
            Entry[] entryArray2 = this.table;
            int n3 = n2 - 1;
            for (int i = 0; i < entryArray2.length; ++i) {
                Entry entry2;
                Entry entry3 = entryArray2[i];
                if (entry3 == null) continue;
                entryArray2[i] = null;
                do {
                    entry2 = entry3.next;
                    n = entry3.key & n3;
                    entry3.next = entryArray[n];
                    entryArray[n] = entry3;
                } while ((entry3 = entry2) != null);
            }
            this.table = entryArray;
            this.capacity = n2;
            this.mask = n3;
            this.threshold = (int)((float)n2 * this.loadFactor);
        }
        return null;
    }

    public T remove(short s) {
        Entry entry;
        int n = s & this.mask;
        Entry entry2 = entry = this.table[n];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == s) {
                --this.size;
                if (entry == entry2) {
                    this.table[n] = entry3;
                } else {
                    entry.next = entry3;
                }
                return (T)entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.size = 0;
    }

    static class Entry {
        final short key;
        Object value;
        Entry next;

        Entry(short s, Object object, Entry entry) {
            this.key = s;
            this.value = object;
            this.next = entry;
        }
    }
}

