/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.util.IntHashMap;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.UdpConnection;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public class Server
implements EndPoint {
    private final Kryo kryo;
    private final int writeBufferSize;
    private final int objectBufferSize;
    private final Selector selector;
    private ServerSocketChannel serverChannel;
    private UdpConnection udp;
    private Connection[] connections = new Connection[0];
    private IntHashMap<Connection> pendingConnections = new IntHashMap();
    Listener[] listeners = new Listener[0];
    private Object listenerLock = new Object();
    private int nextConnectionID = 1;
    private volatile boolean shutdown;
    private Object updateLock = new Object();
    private Thread updateThread;
    private ByteBuffer emptyBuffer = ByteBuffer.allocate(0);
    private Listener dispatchListener = new Listener(){

        public void connected(Connection connection) {
            Listener[] listenerArray = Server.this.listeners;
            int n = listenerArray.length;
            for (int i = 0; i < n; ++i) {
                listenerArray[i].connected(connection);
            }
        }

        public void disconnected(Connection connection) {
            Server.this.removeConnection(connection);
            Listener[] listenerArray = Server.this.listeners;
            int n = listenerArray.length;
            for (int i = 0; i < n; ++i) {
                listenerArray[i].disconnected(connection);
            }
        }

        public void received(Connection connection, Object object) {
            Listener[] listenerArray = Server.this.listeners;
            int n = listenerArray.length;
            for (int i = 0; i < n; ++i) {
                listenerArray[i].received(connection, object);
            }
        }
    };

    public Server() {
        this(16384, 2048);
    }

    public Server(int n, int n2) {
        this(n, n2, new Kryo());
    }

    public Server(int n, int n2, Kryo kryo) {
        this.writeBufferSize = n;
        this.objectBufferSize = n2;
        this.kryo = kryo;
        kryo.register(FrameworkMessage.RegisterTCP.class);
        kryo.register(FrameworkMessage.RegisterUDP.class);
        kryo.register(FrameworkMessage.KeepAlive.class);
        kryo.register(FrameworkMessage.DiscoverHost.class);
        kryo.register(FrameworkMessage.Ping.class);
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error opening selector.", iOException);
        }
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public void bind(int n) throws IOException {
        this.bind(n, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(int n, int n2) throws IOException {
        this.close();
        Object object = this.updateLock;
        synchronized (object) {
            this.selector.wakeup();
            try {
                this.serverChannel = this.selector.provider().openServerSocketChannel();
                this.serverChannel.socket().bind(new InetSocketAddress(n));
                this.serverChannel.configureBlocking(false);
                this.serverChannel.register(this.selector, 16);
                if (Log.DEBUG) {
                    Log.debug("kryonet", "Accepting connections on port: " + n + "/TCP");
                }
                if (n2 != -1) {
                    this.udp = new UdpConnection(this.kryo, this.objectBufferSize);
                    this.udp.bind(this.selector, n2);
                    if (Log.DEBUG) {
                        Log.debug("kryonet", "Accepting connections on port: " + n2 + "/UDP");
                    }
                }
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
        }
        if (Log.INFO) {
            Log.info("kryonet", "Server opened.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int n) throws IOException {
        this.updateThread = Thread.currentThread();
        Set<SelectionKey> set = this.updateLock;
        synchronized (set) {
        }
        if (n > 0) {
            this.selector.select(n);
        } else {
            this.selector.selectNow();
        }
        Set<SelectionKey> set2 = set = this.selector.selectedKeys();
        synchronized (set2) {
            UdpConnection udpConnection = this.udp;
            Connection[] connectionArray = set.iterator();
            while (connectionArray.hasNext()) {
                SelectionKey selectionKey = connectionArray.next();
                connectionArray.remove();
                try {
                    Object object;
                    Connection connection;
                    Object object2;
                    Object object3;
                    int n2 = selectionKey.readyOps();
                    Connection connection2 = (Connection)selectionKey.attachment();
                    if (connection2 != null) {
                        if (udpConnection != null && connection2.udpRemoteAddress == null) continue;
                        if ((n2 & 1) == 1) {
                            try {
                                while ((object3 = connection2.tcp.readObject(connection2)) != null) {
                                    if (Log.DEBUG) {
                                        Object object4 = object2 = object3 == null ? "null" : object3.getClass().getSimpleName();
                                        if (!(object3 instanceof FrameworkMessage)) {
                                            Log.debug("kryonet", connection2 + " received TCP: " + (String)object2);
                                        } else if (Log.TRACE) {
                                            Log.trace("kryonet", connection2 + " received TCP: " + (String)object2);
                                        }
                                    }
                                    connection2.notifyReceived(object3);
                                }
                            }
                            catch (IOException iOException) {
                                if (Log.TRACE) {
                                    Log.trace("kryonet", "Unable to read TCP from: " + connection2, iOException);
                                } else if (Log.DEBUG) {
                                    Log.debug("kryonet", connection2 + " update: " + iOException.getMessage());
                                }
                                connection2.close();
                            }
                            catch (SerializationException serializationException) {
                                if (Log.ERROR) {
                                    Log.error("kryonet", "Error reading TCP from connection: " + connection2, serializationException);
                                }
                                connection2.close();
                            }
                        }
                        if ((n2 & 4) != 4) continue;
                        try {
                            connection2.tcp.writeOperation();
                        }
                        catch (IOException iOException) {
                            if (Log.TRACE) {
                                Log.trace("kryonet", "Unable to write TCP to connection: " + connection2, iOException);
                            } else if (Log.DEBUG) {
                                Log.debug("kryonet", connection2 + " update: " + iOException.getMessage());
                            }
                            connection2.close();
                        }
                        continue;
                    }
                    if ((n2 & 0x10) == 16) {
                        object3 = this.serverChannel;
                        if (object3 == null) continue;
                        try {
                            object2 = ((ServerSocketChannel)object3).accept();
                            if (object2 == null) continue;
                            this.acceptOperation((SocketChannel)object2);
                        }
                        catch (IOException iOException) {
                            if (!Log.DEBUG) continue;
                            Log.debug("kryonet", "Unable to accept new connection.", iOException);
                        }
                        continue;
                    }
                    if (udpConnection == null) continue;
                    try {
                        object3 = udpConnection.readFromAddress();
                    }
                    catch (IOException iOException) {
                        if (!Log.WARN) continue;
                        Log.warn("kryonet", "Error reading UDP data.", iOException);
                        continue;
                    }
                    if (object3 == null) continue;
                    object2 = this.connections;
                    int n3 = ((Connection[])object2).length;
                    for (int i = 0; i < n3; ++i) {
                        connection = object2[i];
                        if (!((InetSocketAddress)object3).equals(connection.udpRemoteAddress)) continue;
                        connection2 = connection;
                        break;
                    }
                    try {
                        object = udpConnection.readObject(connection2);
                    }
                    catch (SerializationException serializationException) {
                        if (!Log.WARN) continue;
                        if (connection2 != null) {
                            if (!Log.ERROR) continue;
                            Log.error("kryonet", "Error reading UDP from connection: " + connection2, serializationException);
                            continue;
                        }
                        Log.warn("kryonet", "Error reading UDP from unregistered address: " + object3, serializationException);
                        continue;
                    }
                    if (object instanceof FrameworkMessage) {
                        if (object instanceof FrameworkMessage.RegisterUDP) {
                            n3 = ((FrameworkMessage.RegisterUDP)object).connectionID;
                            connection = this.pendingConnections.remove(n3);
                            if (connection != null) {
                                if (connection.udpRemoteAddress != null) continue;
                                connection.udpRemoteAddress = object3;
                                this.addConnection(connection);
                                connection.sendTCP(new FrameworkMessage.RegisterUDP());
                                if (Log.DEBUG) {
                                    Log.debug("kryonet", "Port " + udpConnection.datagramChannel.socket().getLocalPort() + "/UDP connected to: " + object3);
                                }
                                connection.notifyConnected();
                                continue;
                            }
                            if (!Log.DEBUG) continue;
                            Log.debug("kryonet", "Ignoring incoming RegisterUDP with invalid connection ID: " + n3);
                            continue;
                        }
                        if (object instanceof FrameworkMessage.DiscoverHost) {
                            try {
                                udpConnection.datagramChannel.send(this.emptyBuffer, (SocketAddress)object3);
                                if (!Log.DEBUG) continue;
                                Log.debug("kryonet", "Responded to host discovery from: " + object3);
                            }
                            catch (IOException iOException) {
                                if (!Log.WARN) continue;
                                Log.warn("kryonet", "Error replying to host discovery from: " + object3, iOException);
                            }
                            continue;
                        }
                    }
                    if (connection2 != null) {
                        if (Log.DEBUG) {
                            String string;
                            String string2 = string = object == null ? "null" : object.getClass().getSimpleName();
                            if (object instanceof FrameworkMessage) {
                                if (Log.TRACE) {
                                    Log.trace("kryonet", connection2 + " received UDP: " + string);
                                }
                            } else {
                                Log.debug("kryonet", connection2 + " received UDP: " + string);
                            }
                        }
                        connection2.notifyReceived(object);
                        continue;
                    }
                    if (!Log.DEBUG) continue;
                    Log.debug("kryonet", "Ignoring UDP from unregistered address: " + object3);
                }
                catch (CancelledKeyException cancelledKeyException) {}
            }
        }
        long l = System.currentTimeMillis();
        for (Connection connection2 : this.connections) {
            if (connection2.tcp.isTimedOut(l)) {
                if (Log.DEBUG) {
                    Log.debug("kryonet", connection2 + " timed out.");
                }
                connection2.close();
                continue;
            }
            if (!connection2.tcp.needsKeepAlive(l)) continue;
            connection2.sendTCP(FrameworkMessage.keepAlive);
        }
    }

    public void run() {
        if (Log.TRACE) {
            Log.trace("kryonet", "Server thread started.");
        }
        this.shutdown = false;
        while (!this.shutdown) {
            try {
                this.update(500);
            }
            catch (IOException iOException) {
                if (Log.ERROR) {
                    Log.error("kryonet", "Error updating server connections.", iOException);
                }
                this.close();
            }
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Server thread stopped.");
        }
    }

    public void start() {
        new Thread((Runnable)this, "Server").start();
    }

    public void stop() {
        if (this.shutdown) {
            return;
        }
        this.close();
        if (Log.TRACE) {
            Log.trace("kryonet", "Server thread stopping.");
        }
        this.shutdown = true;
    }

    private void acceptOperation(SocketChannel socketChannel) {
        block7: {
            Connection connection = this.newConnection();
            connection.initialize(this.kryo, this.writeBufferSize, this.objectBufferSize);
            connection.endPoint = this;
            UdpConnection udpConnection = this.udp;
            if (udpConnection != null) {
                connection.udp = udpConnection;
            }
            try {
                SelectionKey selectionKey = connection.tcp.accept(this.selector, socketChannel);
                selectionKey.attach(connection);
                int n = this.nextConnectionID++;
                if (this.nextConnectionID == -1) {
                    this.nextConnectionID = 1;
                }
                connection.id = n;
                connection.setConnected(true);
                connection.addListener(this.dispatchListener);
                if (udpConnection == null) {
                    this.addConnection(connection);
                } else {
                    this.pendingConnections.put(n, connection);
                }
                FrameworkMessage.RegisterTCP registerTCP = new FrameworkMessage.RegisterTCP();
                registerTCP.connectionID = n;
                connection.sendTCP(registerTCP);
                if (udpConnection == null) {
                    connection.notifyConnected();
                }
            }
            catch (IOException iOException) {
                connection.close();
                if (!Log.DEBUG) break block7;
                Log.debug("kryonet", "Unable to accept TCP connection.", iOException);
            }
        }
    }

    protected Connection newConnection() {
        return new Connection();
    }

    private void addConnection(Connection connection) {
        Connection[] connectionArray = new Connection[this.connections.length + 1];
        connectionArray[0] = connection;
        System.arraycopy(this.connections, 0, connectionArray, 1, this.connections.length);
        this.connections = connectionArray;
    }

    void removeConnection(Connection connection) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>(Arrays.asList(this.connections));
        arrayList.remove(connection);
        this.connections = arrayList.toArray(new Connection[arrayList.size()]);
        this.pendingConnections.remove(connection.id);
    }

    public void sendToAllTCP(Object object) {
        for (Connection connection : this.connections) {
            connection.sendTCP(object);
        }
    }

    public void sendToAllExceptTCP(int n, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id == n) continue;
            connection.sendTCP(object);
        }
    }

    public void sendToTCP(int n, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id != n) continue;
            connection.sendTCP(object);
            break;
        }
    }

    public void sendToAllUDP(Object object) {
        for (Connection connection : this.connections) {
            connection.sendUDP(object);
        }
    }

    public void sendToAllExceptUDP(int n, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id == n) continue;
            connection.sendUDP(object);
        }
    }

    public void sendToUDP(int n, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id != n) continue;
            connection.sendUDP(object);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listenerArray = this.listeners;
            int n = listenerArray.length;
            for (int i = 0; i < n; ++i) {
                if (listener != listenerArray[i]) continue;
                return;
            }
            Listener[] listenerArray2 = new Listener[n + 1];
            listenerArray2[0] = listener;
            System.arraycopy(listenerArray, 0, listenerArray2, 1, n);
            this.listeners = listenerArray2;
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Server listener added: " + listener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listenerArray = this.listeners;
            int n = listenerArray.length;
            Listener[] listenerArray2 = new Listener[n - 1];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Listener listener2 = listenerArray[i];
                if (listener == listener2) continue;
                if (n2 == n - 1) {
                    return;
                }
                listenerArray2[n2++] = listener2;
            }
            this.listeners = listenerArray2;
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Server listener removed: " + listener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        UdpConnection udpConnection;
        Connection[] connectionArray = this.connections;
        if (Log.INFO && connectionArray.length > 0) {
            Log.info("kryonet", "Closing server connections...");
        }
        int n = connectionArray.length;
        for (int i = 0; i < n; ++i) {
            connectionArray[i].close();
        }
        connectionArray = new Connection[]{};
        ServerSocketChannel serverSocketChannel = this.serverChannel;
        if (serverSocketChannel != null) {
            block12: {
                try {
                    serverSocketChannel.close();
                    if (Log.INFO) {
                        Log.info("kryonet", "Server closed.");
                    }
                }
                catch (IOException iOException) {
                    if (!Log.DEBUG) break block12;
                    Log.debug("kryonet", "Unable to close server.", iOException);
                }
            }
            this.serverChannel = null;
        }
        if ((udpConnection = this.udp) != null) {
            udpConnection.close();
            this.udp = null;
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.selector.wakeup();
            try {
                this.selector.selectNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Thread getUpdateThread() {
        return this.updateThread;
    }

    public Connection[] getConnections() {
        return this.connections;
    }
}

