/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryo.Context;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

class TcpConnection {
    private static final int IPTOS_LOWDELAY = 16;
    SocketChannel socketChannel;
    int keepAliveMillis = 8000;
    final ByteBuffer readBuffer;
    final ByteBuffer writeBuffer;
    final ByteBuffer tempWriteBuffer;
    boolean bufferPositionFix;
    int timeoutMillis = 12000;
    private final Kryo kryo;
    private SelectionKey selectionKey;
    private final Object writeLock = new Object();
    private int currentObjectLength;
    private long lastWriteTime;
    private long lastReadTime;

    public TcpConnection(Kryo kryo, int n, int n2) {
        this.kryo = kryo;
        this.writeBuffer = ByteBuffer.allocate(n);
        this.tempWriteBuffer = ByteBuffer.allocate(n2);
        this.readBuffer = ByteBuffer.allocate(n2);
        this.readBuffer.flip();
    }

    public SelectionKey accept(Selector selector, SocketChannel socketChannel) throws IOException {
        try {
            this.socketChannel = socketChannel;
            socketChannel.configureBlocking(false);
            Socket socket = socketChannel.socket();
            socket.setTcpNoDelay(true);
            this.selectionKey = socketChannel.register(selector, 1);
            if (Log.DEBUG) {
                Log.debug("kryonet", "Port " + socketChannel.socket().getLocalPort() + "/TCP connected to: " + socketChannel.socket().getRemoteSocketAddress());
            }
            this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
            return this.selectionKey;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public void connect(Selector selector, SocketAddress socketAddress, int n) throws IOException {
        this.close();
        this.writeBuffer.clear();
        this.readBuffer.clear();
        this.readBuffer.flip();
        try {
            SocketChannel socketChannel = selector.provider().openSocketChannel();
            Socket socket = socketChannel.socket();
            socket.setTcpNoDelay(true);
            socket.setTrafficClass(16);
            socket.connect(socketAddress, n);
            socketChannel.configureBlocking(false);
            this.socketChannel = socketChannel;
            this.selectionKey = socketChannel.register(selector, 1);
            this.selectionKey.attach(this);
            if (Log.DEBUG) {
                Log.debug("kryonet", "Port " + socketChannel.socket().getLocalPort() + "/TCP connected to: " + socketChannel.socket().getRemoteSocketAddress());
            }
            this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            this.close();
            IOException iOException2 = new IOException("Unable to connect to: " + socketAddress);
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    public Object readObject(Connection connection) throws IOException {
        int n;
        int n2;
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        if (this.currentObjectLength == 0) {
            if (!IntSerializer.canRead(this.readBuffer, true)) {
                this.readBuffer.compact();
                n2 = socketChannel.read(this.readBuffer);
                this.readBuffer.flip();
                if (n2 == -1) {
                    throw new SocketException("Connection is closed.");
                }
                this.lastReadTime = System.currentTimeMillis();
                if (!IntSerializer.canRead(this.readBuffer, true)) {
                    return null;
                }
            }
            this.currentObjectLength = IntSerializer.get(this.readBuffer, true);
            if (this.currentObjectLength <= 0) {
                throw new SerializationException("Invalid object length: " + this.currentObjectLength);
            }
            if (this.currentObjectLength > this.readBuffer.capacity()) {
                throw new SerializationException("Unable to read object larger than read buffer: " + this.currentObjectLength);
            }
        }
        n2 = this.currentObjectLength;
        if (this.readBuffer.remaining() < n2) {
            this.readBuffer.compact();
            n = socketChannel.read(this.readBuffer);
            this.readBuffer.flip();
            if (n == -1) {
                throw new SocketException("Connection is closed.");
            }
            this.lastReadTime = System.currentTimeMillis();
            if (this.readBuffer.remaining() < n2) {
                return null;
            }
        }
        this.currentObjectLength = 0;
        n = this.readBuffer.position();
        int n3 = this.readBuffer.limit();
        this.readBuffer.limit(n + n2);
        Context context = Kryo.getContext();
        context.put("connection", connection);
        context.setRemoteEntityID(connection.id);
        Object object = this.kryo.readClassAndObject(this.readBuffer);
        this.readBuffer.limit(n3);
        if (this.readBuffer.position() - n != n2) {
            throw new SerializationException("Incorrect number of bytes (" + (n + n2 - this.readBuffer.position()) + " remaining) used to deserialize object: " + object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOperation() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.writeBuffer.flip();
            if (this.writeToSocket(this.writeBuffer)) {
                this.selectionKey.interestOps(1);
            }
            this.writeBuffer.compact();
        }
    }

    private boolean writeToSocket(ByteBuffer byteBuffer) throws IOException {
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        while (byteBuffer.hasRemaining()) {
            if (this.bufferPositionFix) {
                byteBuffer.compact();
                byteBuffer.flip();
            }
            if (socketChannel.write(byteBuffer) != 0) continue;
        }
        this.lastWriteTime = System.currentTimeMillis();
        return !byteBuffer.hasRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(Connection connection, Object object) throws IOException {
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        Object object2 = this.writeLock;
        synchronized (object2) {
            this.tempWriteBuffer.clear();
            this.tempWriteBuffer.position(5);
            Context context = Kryo.getContext();
            context.put("connection", connection);
            context.setRemoteEntityID(connection.id);
            try {
                this.kryo.writeClassAndObject(this.tempWriteBuffer, object);
            }
            catch (SerializationException serializationException) {
                throw new SerializationException("Unable to serialize object of type: " + object.getClass().getName(), serializationException);
            }
            this.tempWriteBuffer.flip();
            int n = this.tempWriteBuffer.limit() - 5;
            int n2 = IntSerializer.length(n, true);
            int n3 = 5 - n2;
            this.tempWriteBuffer.position(n3);
            IntSerializer.put(this.tempWriteBuffer, n, true);
            this.tempWriteBuffer.position(n3);
            try {
                if (this.writeBuffer.position() > 0) {
                    this.writeBuffer.put(this.tempWriteBuffer);
                } else if (!this.writeToSocket(this.tempWriteBuffer)) {
                    this.writeBuffer.put(this.tempWriteBuffer);
                    this.selectionKey.interestOps(5);
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new SerializationException("Write buffer limit exceeded writing object of type: " + object.getClass().getName(), bufferOverflowException);
            }
            if (Log.DEBUG || Log.TRACE) {
                float f = (float)this.writeBuffer.position() / (float)this.writeBuffer.capacity();
                if (Log.DEBUG && f > 0.75f) {
                    Log.debug("kryonet", connection + " TCP write buffer is approaching capacity: " + f + "%");
                } else if (Log.TRACE && f > 0.25f) {
                    Log.trace("kryonet", connection + " TCP write buffer utilization: " + f + "%");
                }
            }
            this.lastWriteTime = System.currentTimeMillis();
            return this.tempWriteBuffer.limit() - n3;
        }
    }

    public void close() {
        block4: {
            try {
                if (this.socketChannel != null) {
                    this.socketChannel.close();
                    this.socketChannel = null;
                    if (this.selectionKey != null) {
                        this.selectionKey.selector().wakeup();
                    }
                }
            }
            catch (IOException iOException) {
                if (!Log.DEBUG) break block4;
                Log.debug("kryonet", "Unable to close TCP connection.", iOException);
            }
        }
    }

    public boolean needsKeepAlive(long l) {
        return this.socketChannel != null && this.keepAliveMillis > 0 && l - this.lastWriteTime > (long)this.keepAliveMillis;
    }

    public boolean isTimedOut(long l) {
        return this.socketChannel != null && this.timeoutMillis > 0 && l - this.lastReadTime > (long)this.timeoutMillis;
    }
}

