/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet.rmi;

import com.esotericsoftware.kryo.CustomSerialization;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.FieldSerializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryo.util.IntHashMap;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.rmi.RemoteObject;
import com.esotericsoftware.kryonet.rmi.TimeoutException;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSpace {
    private static final Object instancesLock = new Object();
    static ObjectSpace[] instances = new ObjectSpace[0];
    private static final HashMap<Class, CachedMethod[]> methodCache = new HashMap();
    final IntHashMap idToObject = new IntHashMap();
    Connection[] connections = new Connection[0];
    final Object connectionsLock = new Object();
    private final Listener invokeListener = new Listener(){

        public void received(Connection connection, Object object) {
            if (!(object instanceof InvokeMethod)) {
                return;
            }
            if (ObjectSpace.this.connections != null) {
                int n;
                int n2 = ObjectSpace.this.connections.length;
                for (n = 0; n < n2 && connection != ObjectSpace.this.connections[n]; ++n) {
                }
                if (n == n2) {
                    return;
                }
            }
            InvokeMethod invokeMethod = (InvokeMethod)object;
            Object t = ObjectSpace.this.idToObject.get(invokeMethod.objectID);
            if (t == null) {
                if (Log.WARN) {
                    Log.warn("kryonet", "Ignoring remote invocation request for unknown object ID: " + invokeMethod.objectID);
                }
                return;
            }
            ObjectSpace.this.invoke(connection, t, invokeMethod);
        }

        public void disconnected(Connection connection) {
            ObjectSpace.this.removeConnection(connection);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSpace() {
        Object object = instancesLock;
        synchronized (object) {
            ObjectSpace[] objectSpaceArray = instances;
            ObjectSpace[] objectSpaceArray2 = new ObjectSpace[objectSpaceArray.length + 1];
            objectSpaceArray2[0] = this;
            System.arraycopy(objectSpaceArray, 0, objectSpaceArray2, 1, objectSpaceArray.length);
            instances = objectSpaceArray2;
        }
    }

    public ObjectSpace(Connection connection) {
        this();
        this.addConnection(connection);
    }

    public void register(int n, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.idToObject.put(n, object);
        if (Log.TRACE) {
            Log.trace("kryonet", "Object registered with ObjectSpace as " + n + ": " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Connection[] connectionArray = this.connections;
        for (int i = 0; i < connectionArray.length; ++i) {
            connectionArray[i].removeListener(this.invokeListener);
        }
        Object object = instancesLock;
        synchronized (object) {
            ArrayList<ObjectSpace> arrayList = new ArrayList<ObjectSpace>(Arrays.asList(instances));
            arrayList.remove(this);
            instances = arrayList.toArray(new ObjectSpace[arrayList.size()]);
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Closed ObjectSpace.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        Object object = this.connectionsLock;
        synchronized (object) {
            Connection[] connectionArray = new Connection[this.connections.length + 1];
            connectionArray[0] = connection;
            System.arraycopy(this.connections, 0, connectionArray, 1, this.connections.length);
            this.connections = connectionArray;
        }
        connection.addListener(this.invokeListener);
        if (Log.TRACE) {
            Log.trace("kryonet", "Added connection to ObjectSpace: " + connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        connection.removeListener(this.invokeListener);
        Object object = this.connectionsLock;
        synchronized (object) {
            ArrayList<Connection> arrayList = new ArrayList<Connection>(Arrays.asList(this.connections));
            arrayList.remove(connection);
            this.connections = arrayList.toArray(new Connection[arrayList.size()]);
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Removed connection from ObjectSpace: " + connection);
        }
    }

    protected void invoke(Connection connection, Object object, InvokeMethod invokeMethod) {
        Object object2;
        if (Log.DEBUG) {
            object2 = "";
            if (invokeMethod.args != null) {
                object2 = Arrays.deepToString(invokeMethod.args);
                object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
            }
            Log.debug("kryonet", connection + " received: " + object.getClass().getSimpleName() + "#" + invokeMethod.method.getName() + "(" + (String)object2 + ")");
        }
        Method method = invokeMethod.method;
        try {
            object2 = method.invoke(object, invokeMethod.args);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error invoking method: " + method.getDeclaringClass().getName() + "." + method.getName(), exception);
        }
        byte by = invokeMethod.responseID;
        if (method.getReturnType() == Void.TYPE || by == 0) {
            return;
        }
        InvokeMethodResult invokeMethodResult = new InvokeMethodResult();
        invokeMethodResult.objectID = invokeMethod.objectID;
        invokeMethodResult.responseID = by;
        invokeMethodResult.result = object2;
        int n = connection.sendTCP(invokeMethodResult);
        if (Log.DEBUG) {
            Log.debug("kryonet", connection + " sent: " + object2 + " (" + n + ")");
        }
    }

    public static <T> T getRemoteObject(Connection connection, int n, Class<T> clazz) {
        return (T)ObjectSpace.getRemoteObject(connection, n, new Class[]{clazz});
    }

    public static RemoteObject getRemoteObject(Connection connection, int n, Class ... classArray) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        if (classArray == null) {
            throw new IllegalArgumentException("ifaces cannot be null.");
        }
        Class[] classArray2 = new Class[classArray.length + 1];
        classArray2[0] = RemoteObject.class;
        System.arraycopy(classArray, 0, classArray2, 1, classArray.length);
        return (RemoteObject)Proxy.newProxyInstance(ObjectSpace.class.getClassLoader(), classArray2, (InvocationHandler)new RemoteInvocationHandler(connection, n));
    }

    static CachedMethod[] getMethods(Kryo kryo, Class clazz) {
        Object object;
        int n;
        CachedMethod[] cachedMethodArray = methodCache.get(clazz);
        if (cachedMethodArray != null) {
            return cachedMethodArray;
        }
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 = clazz; clazz2 != null && clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Collections.addAll(arrayList, clazz2.getDeclaredMethods());
        }
        PriorityQueue<Method> priorityQueue = new PriorityQueue<Method>(Math.max(1, arrayList.size()), new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                Class<?>[] classArray;
                int n = method.getName().compareTo(method2.getName());
                if (n != 0) {
                    return n;
                }
                Class<?>[] classArray2 = method.getParameterTypes();
                if (classArray2.length > (classArray = method2.getParameterTypes()).length) {
                    return 1;
                }
                if (classArray2.length < classArray.length) {
                    return -1;
                }
                for (int i = 0; i < classArray2.length; ++i) {
                    n = classArray2[i].getName().compareTo(classArray[i].getName());
                    if (n == 0) continue;
                    return n;
                }
                throw new RuntimeException("Two methods with same signature!");
            }
        });
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (Method)arrayList.get(n);
            int n3 = ((Method)object).getModifiers();
            if (Modifier.isStatic(n3) || Modifier.isPrivate(n3) || ((Method)object).isSynthetic()) continue;
            priorityQueue.add((Method)object);
        }
        n = priorityQueue.size();
        cachedMethodArray = new CachedMethod[n];
        for (n2 = 0; n2 < n; ++n2) {
            object = new CachedMethod();
            ((CachedMethod)object).method = priorityQueue.poll();
            Class<?>[] classArray = ((CachedMethod)object).method.getParameterTypes();
            ((CachedMethod)object).serializers = new Serializer[classArray.length];
            int n4 = classArray.length;
            for (int i = 0; i < n4; ++i) {
                if (!Kryo.isFinal(classArray[i])) continue;
                ((CachedMethod)object).serializers[i] = kryo.getSerializer(classArray[i]);
            }
            cachedMethodArray[n2] = object;
        }
        methodCache.put(clazz, cachedMethodArray);
        return cachedMethodArray;
    }

    static Object getRegisteredObject(Connection connection, int n) {
        for (ObjectSpace objectSpace : instances) {
            Connection[] connectionArray = objectSpace.connections;
            for (int i = 0; i < connectionArray.length; ++i) {
                Object t;
                if (connectionArray[i] != connection || (t = objectSpace.idToObject.get(n)) == null) continue;
                return t;
            }
        }
        return null;
    }

    public static void registerClasses(Kryo kryo) {
        kryo.register(Object[].class);
        kryo.register(InvokeMethod.class);
        FieldSerializer fieldSerializer = (FieldSerializer)kryo.register(InvokeMethodResult.class).getSerializer();
        fieldSerializer.getField("objectID").setClass(Integer.TYPE, new IntSerializer(true));
        kryo.register(InvocationHandler.class, new Serializer(){

            @Override
            public void writeObjectData(ByteBuffer byteBuffer, Object object) {
                RemoteInvocationHandler remoteInvocationHandler = (RemoteInvocationHandler)Proxy.getInvocationHandler(object);
                IntSerializer.put(byteBuffer, remoteInvocationHandler.objectID, true);
            }

            @Override
            public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> clazz) {
                int n = IntSerializer.get(byteBuffer, true);
                Connection connection = (Connection)Kryo.getContext().get("connection");
                Object object = ObjectSpace.getRegisteredObject(connection, n);
                if (Log.WARN && object == null) {
                    Log.warn("kryonet", "Unknown object ID " + n + " for connection: " + connection);
                }
                return (T)object;
            }
        });
    }

    static class CachedMethod {
        Method method;
        Serializer[] serializers;

        CachedMethod() {
        }
    }

    public static class InvokeMethodResult
    implements FrameworkMessage {
        public int objectID;
        public byte responseID;
        public Object result;
    }

    public static class InvokeMethod
    implements FrameworkMessage,
    CustomSerialization {
        public int objectID;
        public Method method;
        public Object[] args;
        public byte responseID;

        public void writeObjectData(Kryo kryo, ByteBuffer byteBuffer) {
            int n;
            IntSerializer.put(byteBuffer, this.objectID, true);
            int n2 = kryo.getRegisteredClass(this.method.getDeclaringClass()).getID();
            IntSerializer.put(byteBuffer, n2, true);
            CachedMethod[] cachedMethodArray = ObjectSpace.getMethods(kryo, this.method.getDeclaringClass());
            CachedMethod cachedMethod = null;
            int n3 = cachedMethodArray.length;
            for (n = 0; n < n3; ++n) {
                cachedMethod = cachedMethodArray[n];
                if (!cachedMethod.method.equals(this.method)) continue;
                byteBuffer.put((byte)n);
                break;
            }
            n3 = cachedMethod.serializers.length;
            for (n = 0; n < n3; ++n) {
                Serializer serializer = cachedMethod.serializers[n];
                if (serializer != null) {
                    serializer.writeObject(byteBuffer, this.args[n]);
                    continue;
                }
                kryo.writeClassAndObject(byteBuffer, this.args[n]);
            }
            if (this.method.getReturnType() != Void.TYPE) {
                byteBuffer.put(this.responseID);
            }
        }

        public void readObjectData(Kryo kryo, ByteBuffer byteBuffer) {
            CachedMethod cachedMethod;
            this.objectID = IntSerializer.get(byteBuffer, true);
            int n = IntSerializer.get(byteBuffer, true);
            Class clazz = kryo.getRegisteredClass(n).getType();
            byte by = byteBuffer.get();
            try {
                cachedMethod = ObjectSpace.getMethods(kryo, clazz)[by];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new SerializationException("Invalid method index " + by + " for class: " + clazz.getName());
            }
            this.method = cachedMethod.method;
            this.args = new Object[cachedMethod.serializers.length];
            int n2 = this.args.length;
            for (int i = 0; i < n2; ++i) {
                Serializer serializer = cachedMethod.serializers[i];
                this.args[i] = serializer != null ? serializer.readObject(byteBuffer, this.method.getParameterTypes()[i]) : kryo.readClassAndObject(byteBuffer);
            }
            if (this.method.getReturnType() != Void.TYPE) {
                this.responseID = byteBuffer.get();
            }
        }
    }

    private static class RemoteInvocationHandler
    implements InvocationHandler {
        private final Connection connection;
        final int objectID;
        private int timeoutMillis = 3000;
        private boolean nonBlocking;
        private boolean ignoreResponses;
        private Byte lastResponseID;
        final ArrayList<InvokeMethodResult> responseQueue = new ArrayList();
        private byte nextResponseID = 1;
        private Listener responseListener;

        public RemoteInvocationHandler(Connection connection, final int n) {
            this.connection = connection;
            this.objectID = n;
            this.responseListener = new Listener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void received(Connection connection, Object object) {
                    if (!(object instanceof InvokeMethodResult)) {
                        return;
                    }
                    InvokeMethodResult invokeMethodResult = (InvokeMethodResult)object;
                    if (invokeMethodResult.objectID != n) {
                        return;
                    }
                    ArrayList<InvokeMethodResult> arrayList = RemoteInvocationHandler.this.responseQueue;
                    synchronized (arrayList) {
                        RemoteInvocationHandler.this.responseQueue.add(invokeMethodResult);
                        RemoteInvocationHandler.this.responseQueue.notifyAll();
                    }
                }

                public void disconnected(Connection connection) {
                    RemoteInvocationHandler.this.close();
                }
            };
            connection.addListener(this.responseListener);
        }

        public Object invoke(Object object, Method method, Object[] objectArray) {
            Object object2;
            int n;
            boolean bl;
            Object object3;
            if (method.getDeclaringClass() == RemoteObject.class) {
                object3 = method.getName();
                if (((String)object3).equals("close")) {
                    this.close();
                    return null;
                }
                if (((String)object3).equals("setResponseTimeout")) {
                    this.timeoutMillis = (Integer)objectArray[0];
                    return null;
                }
                if (((String)object3).equals("setNonBlocking")) {
                    this.nonBlocking = (Boolean)objectArray[0];
                    this.ignoreResponses = (Boolean)objectArray[1];
                    return null;
                }
                if (((String)object3).equals("waitForLastResponse")) {
                    if (this.lastResponseID == null) {
                        throw new IllegalStateException("There is no last response to wait for.");
                    }
                    return this.waitForResponse(this.lastResponseID.byteValue());
                }
                if (((String)object3).equals("getLastResponseID")) {
                    if (this.lastResponseID == null) {
                        throw new IllegalStateException("There is no last response ID.");
                    }
                    return this.lastResponseID;
                }
                if (((String)object3).equals("waitForResponse")) {
                    if (this.ignoreResponses) {
                        throw new IllegalStateException("This RemoteObject is configured to ignore all responses.");
                    }
                    return this.waitForResponse(((Byte)objectArray[0]).byteValue());
                }
            }
            object3 = new InvokeMethod();
            ((InvokeMethod)object3).objectID = this.objectID;
            ((InvokeMethod)object3).method = method;
            ((InvokeMethod)object3).args = objectArray;
            boolean bl2 = bl = method.getReturnType() != Void.TYPE;
            if (bl && !this.ignoreResponses) {
                byte by = this.nextResponseID;
                this.nextResponseID = (byte)(by + 1);
                n = by;
                if (this.nextResponseID == 0) {
                    this.nextResponseID = (byte)(this.nextResponseID + 1);
                }
                ((InvokeMethod)object3).responseID = (byte)n;
            }
            n = this.connection.sendTCP(object3);
            if (Log.DEBUG) {
                object2 = "";
                if (objectArray != null) {
                    object2 = Arrays.deepToString(objectArray);
                    object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                }
                Log.debug("kryonet", this.connection + " sent: " + method.getDeclaringClass().getSimpleName() + "#" + method.getName() + "(" + (String)object2 + ") (" + n + ")");
            }
            if (!bl) {
                return null;
            }
            if (this.nonBlocking) {
                if (!this.ignoreResponses) {
                    this.lastResponseID = ((InvokeMethod)object3).responseID;
                }
                if (((Class)(object2 = method.getReturnType())).isPrimitive()) {
                    if (object2 == Integer.TYPE) {
                        return 0;
                    }
                    if (object2 == Boolean.TYPE) {
                        return Boolean.FALSE;
                    }
                    if (object2 == Float.TYPE) {
                        return Float.valueOf(0.0f);
                    }
                    if (object2 == Character.TYPE) {
                        return Character.valueOf('\u0000');
                    }
                    if (object2 == Long.TYPE) {
                        return 0L;
                    }
                    if (object2 == Short.TYPE) {
                        return (short)0;
                    }
                    if (object2 == Byte.TYPE) {
                        return (byte)0;
                    }
                    if (object2 == Double.TYPE) {
                        return 0.0;
                    }
                }
                return null;
            }
            try {
                return this.waitForResponse(((InvokeMethod)object3).responseID);
            }
            catch (TimeoutException timeoutException) {
                throw new TimeoutException("Response timed out: " + method.getDeclaringClass().getName() + "." + method.getName());
            }
        }

        private Object waitForResponse(int n) {
            if (this.connection.getEndPoint().getUpdateThread() == Thread.currentThread()) {
                throw new IllegalStateException("Cannot wait for an RMI response on the connection's update thread.");
            }
            long l = System.currentTimeMillis() + (long)this.timeoutMillis;
            ArrayList<InvokeMethodResult> arrayList = this.responseQueue;
            synchronized (arrayList) {
                block5: while (true) {
                    while (true) {
                        int n2 = (int)(l - System.currentTimeMillis());
                        for (int i = this.responseQueue.size() - 1; i >= 0; ++i) {
                            InvokeMethodResult invokeMethodResult = this.responseQueue.get(i);
                            if (invokeMethodResult.responseID != n) continue;
                            this.responseQueue.remove(invokeMethodResult);
                            this.lastResponseID = null;
                            return invokeMethodResult.result;
                        }
                        if (n2 <= 0) {
                            throw new TimeoutException("Response timed out.");
                        }
                        try {
                            this.responseQueue.wait(n2);
                            continue block5;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }

        void close() {
            this.connection.removeListener(this.responseListener);
        }
    }
}

