/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.compress;

import com.esotericsoftware.kryo.Compressor;
import com.esotericsoftware.kryo.Context;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import java.nio.ByteBuffer;

public abstract class ByteArrayCompressor
extends Compressor {
    public ByteArrayCompressor(Serializer serializer) {
        super(serializer);
    }

    public ByteArrayCompressor(Serializer serializer, int n) {
        super(serializer, n);
    }

    public void compress(ByteBuffer byteBuffer, Object object, ByteBuffer byteBuffer2) {
        Context context = Kryo.getContext();
        int n = byteBuffer.remaining();
        byte[] byArray = context.getBuffer(Math.max(n, this.bufferSize)).array();
        byteBuffer.get(byArray, 0, n);
        this.compress(byArray, n, byteBuffer2);
    }

    public abstract void compress(byte[] var1, int var2, ByteBuffer var3);

    public void decompress(ByteBuffer byteBuffer, Class clazz, ByteBuffer byteBuffer2) {
        Context context = Kryo.getContext();
        int n = byteBuffer.remaining();
        byte[] byArray = context.getBuffer(Math.max(n, this.bufferSize)).array();
        byteBuffer.get(byArray, 0, n);
        this.decompress(byArray, n, byteBuffer2);
    }

    public abstract void decompress(byte[] var1, int var2, ByteBuffer var3);
}

