/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.compress;

import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.compress.ByteArrayCompressor;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class StreamCompressor
extends ByteArrayCompressor {
    public StreamCompressor(Serializer serializer) {
        super(serializer, 2048);
    }

    public StreamCompressor(Serializer serializer, int n) {
        super(serializer, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress(byte[] byArray, int n, ByteBuffer byteBuffer) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byteBuffer.array());
        try {
            FilterOutputStream filterOutputStream = this.getCompressionStream(byteArrayOutputStream);
            try {
                filterOutputStream.write(byArray, 0, n);
            }
            finally {
                filterOutputStream.close();
            }
            byteBuffer.position(byteArrayOutputStream.size());
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public abstract FilterOutputStream getCompressionStream(OutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompress(byte[] byArray, int n, ByteBuffer byteBuffer) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream.setCount(n);
        try {
            FilterInputStream filterInputStream = this.getDecompressionStream(byteArrayInputStream);
            try {
                byteBuffer.position(filterInputStream.read(byteBuffer.array(), 0, byteBuffer.capacity()));
            }
            finally {
                filterInputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public abstract FilterInputStream getDecompressionStream(InputStream var1) throws IOException;

    private static class ByteArrayInputStream
    extends java.io.ByteArrayInputStream {
        public ByteArrayInputStream(byte[] byArray) {
            super(byArray);
        }

        public void setCount(int n) {
            this.count = n;
        }
    }

    private static class ByteArrayOutputStream
    extends java.io.ByteArrayOutputStream {
        public ByteArrayOutputStream(byte[] byArray) {
            super(0);
            this.buf = byArray;
        }
    }
}

