/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.ByteSerializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySerializer
extends Serializer {
    private final Kryo kryo;
    private Integer fixedDimensionCount;
    private boolean elementsAreSameType;
    private boolean elementsCanBeNull = true;
    private int[] dimensions;

    public ArraySerializer(Kryo kryo) {
        this.kryo = kryo;
    }

    public void setDimensionCount(Integer n) {
        this.fixedDimensionCount = n;
    }

    public void setLength(int n) {
        this.dimensions = new int[]{n};
    }

    public void setLengths(int[] nArray) {
        this.dimensions = nArray;
    }

    public void setElementsCanBeNull(boolean bl) {
        this.elementsCanBeNull = bl;
    }

    public void setElementsAreSameType(boolean bl) {
        this.elementsAreSameType = bl;
    }

    @Override
    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        boolean bl;
        int[] nArray = this.dimensions;
        if (nArray == null) {
            nArray = ArraySerializer.getDimensions(object);
            if (this.fixedDimensionCount == null) {
                ByteSerializer.putUnsigned(byteBuffer, nArray.length);
            }
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                IntSerializer.put(byteBuffer, nArray[i], true);
            }
        }
        Serializer serializer = null;
        Class clazz = ArraySerializer.getElementClass(object.getClass());
        boolean bl2 = bl = this.elementsCanBeNull && !clazz.isPrimitive();
        if (this.elementsAreSameType || Modifier.isFinal(clazz.getModifiers())) {
            serializer = this.kryo.getRegisteredClass(clazz).getSerializer();
        }
        this.writeArray(byteBuffer, object, serializer, 0, nArray.length, bl);
        if (Log.TRACE) {
            StringBuilder stringBuilder = new StringBuilder(16);
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append('[');
                stringBuilder.append(nArray[i]);
                stringBuilder.append(']');
            }
            Log.trace("kryo", "Wrote array: " + clazz.getName() + stringBuilder);
        }
    }

    private void writeArray(ByteBuffer byteBuffer, Object object, Serializer serializer, int n, int n2, boolean bl) {
        int n3 = Array.getLength(object);
        if (n > 0) {
            IntSerializer.put(byteBuffer, n3, true);
        }
        boolean bl2 = n < n2 - 1;
        for (int i = 0; i < n3; ++i) {
            Object object2 = Array.get(object, i);
            if (bl2) {
                if (object2 == null) continue;
                this.writeArray(byteBuffer, object2, serializer, n + 1, n2, bl);
                continue;
            }
            if (serializer != null) {
                if (bl) {
                    serializer.writeObject(byteBuffer, object2);
                    continue;
                }
                serializer.writeObjectData(byteBuffer, object2);
                continue;
            }
            this.kryo.writeClassAndObject(byteBuffer, object2);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> clazz) {
        boolean bl;
        int n;
        int[] nArray = this.dimensions;
        if (nArray == null) {
            n = this.fixedDimensionCount != null ? this.fixedDimensionCount : ByteSerializer.getUnsigned(byteBuffer);
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = IntSerializer.get(byteBuffer, true);
            }
        } else {
            n = nArray.length;
        }
        Serializer serializer = null;
        Class clazz2 = ArraySerializer.getElementClass(clazz);
        boolean bl2 = bl = this.elementsCanBeNull && !clazz2.isPrimitive();
        if (this.elementsAreSameType || Modifier.isFinal(clazz2.getModifiers())) {
            serializer = this.kryo.getRegisteredClass(clazz2).getSerializer();
        }
        Object object = Array.newInstance(clazz2, nArray);
        this.readArray(byteBuffer, object, serializer, clazz2, 0, nArray, bl);
        if (Log.TRACE) {
            StringBuilder stringBuilder = new StringBuilder(16);
            for (int i = 0; i < n; ++i) {
                stringBuilder.append('[');
                stringBuilder.append(nArray[i]);
                stringBuilder.append(']');
            }
            Log.trace("kryo", "Read array: " + clazz2.getName() + stringBuilder);
        }
        return (T)object;
    }

    private void readArray(ByteBuffer byteBuffer, Object object, Serializer serializer, Class clazz, int n, int[] nArray, boolean bl) {
        boolean bl2 = n < nArray.length - 1;
        int n2 = n == 0 ? nArray[0] : IntSerializer.get(byteBuffer, true);
        for (int i = 0; i < n2; ++i) {
            if (bl2) {
                Object object2 = Array.get(object, i);
                if (object2 == null) continue;
                this.readArray(byteBuffer, object2, serializer, clazz, n + 1, nArray, bl);
                continue;
            }
            if (serializer != null) {
                if (bl) {
                    Array.set(object, i, serializer.readObject(byteBuffer, clazz));
                    continue;
                }
                Array.set(object, i, serializer.readObjectData(byteBuffer, clazz));
                continue;
            }
            Array.set(object, i, this.kryo.readClassAndObject(byteBuffer));
        }
    }

    public static int getDimensionCount(Class clazz) {
        int n = 0;
        for (Class<?> clazz2 = clazz.getComponentType(); clazz2 != null; clazz2 = clazz2.getComponentType()) {
            ++n;
        }
        return n;
    }

    public static int[] getDimensions(Object object) {
        int n = 0;
        for (Class<?> clazz = object.getClass().getComponentType(); clazz != null; clazz = clazz.getComponentType()) {
            ++n;
        }
        int[] nArray = new int[n];
        nArray[0] = Array.getLength(object);
        if (n > 1) {
            ArraySerializer.collectDimensions(object, 1, nArray);
        }
        return nArray;
    }

    private static void collectDimensions(Object object, int n, int[] nArray) {
        boolean bl = n < nArray.length - 1;
        int n2 = Array.getLength(object);
        for (int i = 0; i < n2; ++i) {
            Object object2 = Array.get(object, i);
            if (object2 == null) continue;
            nArray[n] = Math.max(nArray[n], Array.getLength(object2));
            if (!bl) continue;
            ArraySerializer.collectDimensions(object2, n + 1, nArray);
        }
    }

    public static Class getElementClass(Class clazz) {
        Class<?> clazz2 = clazz;
        while (clazz2.getComponentType() != null) {
            clazz2 = clazz2.getComponentType();
        }
        return clazz2;
    }
}

