/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Context;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.NotNull;
import com.esotericsoftware.kryo.Optional;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryo.serialize.StringSerializer;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.reflectasm.FieldAccess;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibleFieldSerializer
extends Serializer {
    final Kryo kryo;
    final Class type;
    private CachedField[] fields;
    Object access;
    private boolean fieldsCanBeNull = true;
    private boolean setFieldsAsAccessible = true;

    public CompatibleFieldSerializer(Kryo kryo, Class clazz) {
        this.kryo = kryo;
        this.type = clazz;
        this.rebuildCachedFields();
    }

    private void rebuildCachedFields() {
        Object object;
        int n;
        if (this.type.isInterface()) {
            this.fields = new CachedField[0];
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (Class clazz = this.type; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Collections.addAll(arrayList, clazz.getDeclaredFields());
        }
        ArrayList<CachedField> arrayList2 = new ArrayList<CachedField>();
        PriorityQueue<CachedField> priorityQueue = new PriorityQueue<CachedField>(Math.max(1, arrayList.size()), new Comparator<CachedField>(){

            @Override
            public int compare(CachedField cachedField, CachedField cachedField2) {
                return cachedField.field.getName().compareTo(cachedField2.field.getName());
            }
        });
        Context context = Kryo.getContext();
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            Optional optional;
            object = (Field)arrayList.get(n);
            int n3 = ((Field)object).getModifiers();
            if (Modifier.isTransient(n3) || Modifier.isStatic(n3) || ((Field)object).isSynthetic()) continue;
            if (!((AccessibleObject)object).isAccessible()) {
                if (!this.setFieldsAsAccessible) continue;
                try {
                    ((Field)object).setAccessible(true);
                }
                catch (AccessControlException accessControlException) {
                    continue;
                }
            }
            if ((optional = ((Field)object).getAnnotation(Optional.class)) != null && context.get(optional.value()) == null) continue;
            Class<?> clazz = ((Field)object).getType();
            CachedField cachedField = new CachedField();
            cachedField.field = object;
            cachedField.canBeNull = this.fieldsCanBeNull ? !clazz.isPrimitive() && !((AccessibleObject)object).isAnnotationPresent(NotNull.class) : false;
            if (this.isFinal(clazz)) {
                cachedField.fieldClass = clazz;
            }
            priorityQueue.add(cachedField);
            if (!Modifier.isPublic(n3) || !Modifier.isPublic(clazz.getModifiers())) continue;
            arrayList2.add(cachedField);
        }
        if (!Util.isAndroid && Modifier.isPublic(this.type.getModifiers()) && !arrayList2.isEmpty()) {
            try {
                this.access = FieldAccess.get(this.type);
                n2 = arrayList2.size();
                for (n = 0; n < n2; ++n) {
                    object = (CachedField)arrayList2.get(n);
                    ((CachedField)object).accessIndex = ((FieldAccess)this.access).getIndex(((CachedField)object).field.getName());
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        int n4 = priorityQueue.size();
        this.fields = new CachedField[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            this.fields[n2] = priorityQueue.poll();
        }
    }

    public void setFieldsCanBeNull(boolean bl) {
        this.fieldsCanBeNull = bl;
        this.rebuildCachedFields();
    }

    public void setFieldsAsAccessible(boolean bl) {
        this.setFieldsAsAccessible = bl;
        this.rebuildCachedFields();
    }

    @Override
    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        Context context = Kryo.getContext();
        if (context.getTemp(this, "schemaWritten") == null) {
            context.putTemp(this, "schemaWritten", Boolean.TRUE);
            if (Log.TRACE) {
                Log.trace("kryo", "Writing " + this.fields.length + " field names.");
            }
            IntSerializer.put(byteBuffer, this.fields.length, true);
            int n = this.fields.length;
            for (int i = 0; i < n; ++i) {
                StringSerializer.put(byteBuffer, this.fields[i].field.getName());
            }
        }
        for (CachedField cachedField : this.fields) {
            try {
                Object object2;
                if (Log.TRACE) {
                    Log.trace("kryo", "Writing field: " + cachedField + " (" + object.getClass().getName() + ")");
                }
                if ((object2 = cachedField.get(object)) == null) {
                    this.kryo.writeClass(byteBuffer, null);
                    continue;
                }
                int n = byteBuffer.position();
                try {
                    byteBuffer.position(n + 1);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    new BufferOverflowException();
                }
                Serializer serializer = cachedField.serializer;
                if (cachedField.fieldClass == null) {
                    Kryo.RegisteredClass registeredClass = this.kryo.writeClass(byteBuffer, object2.getClass());
                    if (serializer == null) {
                        serializer = registeredClass.getSerializer();
                    }
                    serializer.writeObjectData(byteBuffer, object2);
                } else {
                    if (serializer == null) {
                        cachedField.serializer = serializer = this.kryo.getRegisteredClass(cachedField.fieldClass).getSerializer();
                    }
                    if (!cachedField.canBeNull) {
                        serializer.writeObjectData(byteBuffer, object2);
                    } else {
                        serializer.writeObject(byteBuffer, object2);
                    }
                }
                int n2 = byteBuffer.position() - n - 1;
                if (n2 <= 127) {
                    byteBuffer.put(n, (byte)n2);
                    continue;
                }
                byte[] byArray = context.getByteArray(n2);
                byteBuffer.position(n + 1);
                byteBuffer.get(byArray, 0, n2);
                byteBuffer.position(n);
                IntSerializer.put(byteBuffer, n2, true);
                byteBuffer.put(byArray, 0, n2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SerializationException("Error accessing field in class: " + object.getClass().getName(), illegalAccessException);
            }
            catch (SerializationException serializationException) {
                serializationException.addTrace(cachedField + " (" + object.getClass().getName() + ")");
                throw serializationException;
            }
            catch (RuntimeException runtimeException) {
                SerializationException serializationException = new SerializationException(runtimeException);
                serializationException.addTrace(cachedField + " (" + object.getClass().getName() + ")");
                throw serializationException;
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote object: " + object);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> clazz) {
        return this.readObjectData(this.newInstance(this.kryo, clazz), byteBuffer, clazz);
    }

    protected <T> T readObjectData(T t, ByteBuffer byteBuffer, Class<T> clazz) {
        int n;
        Context context = Kryo.getContext();
        CachedField[] cachedFieldArray = (CachedField[])context.getTemp(this, "schema");
        if (cachedFieldArray == null) {
            n = IntSerializer.get(byteBuffer, true);
            if (Log.TRACE) {
                Log.trace("kryo", "Reading " + n + " field names.");
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = StringSerializer.get(byteBuffer);
            }
            cachedFieldArray = new CachedField[n];
            CachedField[] cachedFieldArray2 = this.fields;
            block7: for (String object : stringArray) {
                int n2 = cachedFieldArray2.length;
                for (int i = 0; i < n2; ++i) {
                    if (!cachedFieldArray2[i].field.getName().equals(object)) continue;
                    cachedFieldArray[var9_12] = cachedFieldArray2[i];
                    continue block7;
                }
                if (!Log.TRACE) continue;
                Log.trace("kryo", "Ignoring obsolete field: " + object);
            }
            context.putTemp(this, "schema", cachedFieldArray);
        }
        int n3 = cachedFieldArray.length;
        for (n = 0; n < n3; ++n) {
            int n4 = IntSerializer.get(byteBuffer, true);
            CachedField cachedField = cachedFieldArray[n];
            try {
                Object var10_16;
                if (cachedField == null) {
                    if (Log.TRACE) {
                        Log.trace("kryo", "Skipping obsolete field bytes: " + n4);
                    }
                    try {
                        byteBuffer.position(byteBuffer.position() + n4);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        new BufferOverflowException();
                    }
                    continue;
                }
                if (Log.TRACE) {
                    Log.trace("kryo", "Reading field: " + cachedField + " (" + clazz.getName() + ")");
                }
                if (n4 == 0) {
                    var10_16 = null;
                } else {
                    Class clazz2 = cachedField.fieldClass;
                    Serializer serializer = cachedField.serializer;
                    if (clazz2 == null) {
                        Kryo.RegisteredClass registeredClass = this.kryo.readClass(byteBuffer);
                        if (registeredClass == null) {
                            var10_16 = null;
                        } else {
                            Class clazz3 = registeredClass.getType();
                            if (serializer == null) {
                                serializer = registeredClass.getSerializer();
                            }
                            var10_16 = serializer.readObjectData(byteBuffer, clazz3);
                        }
                    } else {
                        if (serializer == null) {
                            cachedField.serializer = serializer = this.kryo.getRegisteredClass(clazz2).getSerializer();
                        }
                        var10_16 = !cachedField.canBeNull ? serializer.readObjectData(byteBuffer, clazz2) : serializer.readObject(byteBuffer, clazz2);
                    }
                }
                cachedField.set(t, var10_16);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SerializationException("Error accessing field in class: " + clazz.getName(), illegalAccessException);
            }
            catch (SerializationException serializationException) {
                serializationException.addTrace(cachedField + " (" + clazz.getName() + ")");
                throw serializationException;
            }
            catch (RuntimeException runtimeException) {
                SerializationException serializationException = new SerializationException(runtimeException);
                serializationException.addTrace(cachedField + " (" + clazz.getName() + ")");
                throw serializationException;
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read object: " + t);
        }
        return t;
    }

    public CachedField getField(String string) {
        for (CachedField cachedField : this.fields) {
            if (!cachedField.field.getName().equals(string)) continue;
            return cachedField;
        }
        throw new IllegalArgumentException("Field \"" + string + "\" not found on class: " + this.type.getName());
    }

    public void removeField(String string) {
        for (int i = 0; i < this.fields.length; ++i) {
            CachedField cachedField = this.fields[i];
            if (!cachedField.field.getName().equals(string)) continue;
            CachedField[] cachedFieldArray = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, cachedFieldArray, 0, i);
            System.arraycopy(this.fields, i + 1, cachedFieldArray, i, cachedFieldArray.length - i);
            this.fields = cachedFieldArray;
            return;
        }
        throw new IllegalArgumentException("Field \"" + string + "\" not found on class: " + this.type.getName());
    }

    public class CachedField {
        Field field;
        Class fieldClass;
        Serializer serializer;
        boolean canBeNull;
        int accessIndex = -1;

        public void setClass(Class clazz) {
            this.fieldClass = clazz;
            this.serializer = null;
        }

        public void setClass(Class clazz, Serializer serializer) {
            this.fieldClass = clazz;
            this.serializer = serializer;
        }

        public void setCanBeNull(boolean bl) {
            this.canBeNull = bl;
        }

        public String toString() {
            return this.field.getName();
        }

        Object get(Object object) throws IllegalAccessException {
            if (this.accessIndex != -1) {
                return ((FieldAccess)CompatibleFieldSerializer.this.access).get(object, this.accessIndex);
            }
            return this.field.get(object);
        }

        void set(Object object, Object object2) throws IllegalAccessException {
            if (this.accessIndex != -1) {
                ((FieldAccess)CompatibleFieldSerializer.this.access).set(object, this.accessIndex, object2);
            } else {
                this.field.set(object, object2);
            }
        }
    }
}

