/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.LongSerializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class DoubleSerializer
extends Serializer {
    private final double precision;
    private final boolean optimizePositive;

    public DoubleSerializer() {
        this.precision = 0.0;
        this.optimizePositive = false;
    }

    public DoubleSerializer(double d, boolean bl) {
        this.precision = d;
        this.optimizePositive = bl;
    }

    public Double readObjectData(ByteBuffer byteBuffer, Class clazz) {
        double d = this.precision == 0.0 ? byteBuffer.getDouble() : (double)LongSerializer.get(byteBuffer, this.optimizePositive) / this.precision;
        if (Log.TRACE) {
            Log.trace("kryo", "Read double: " + d);
        }
        return d;
    }

    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        if (this.precision == 0.0) {
            byteBuffer.putDouble((Double)object);
        } else {
            LongSerializer.put(byteBuffer, (long)((Double)object * this.precision), this.optimizePositive);
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote double: " + object);
        }
    }
}

