/*
 * Decompiled with CFR 0.152.
 */
package gr.ratmole.android.Mach3PendantServer;

import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Server;
import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.ProcessInfo;
import com.sun.jna.Native;
import com.sun.jna.PointerType;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import gr.ratmole.android.shared.Event;
import gr.ratmole.android.shared.EventSequence;
import gr.ratmole.android.shared.Handshake;
import gr.ratmole.android.shared.KeyEvent;
import gr.ratmole.android.shared.MapStringToKeyCode;
import gr.ratmole.android.shared.Network;
import gr.ratmole.android.shared.ServerGreeting;
import gr.ratmole.android.shared.ServerWindow;
import java.awt.AWTException;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Robot;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4J;

public class Mach3PendantServer {
    private static final String propertiesFileName = "Mach3PendantServer.properties";
    private static final String APP_NAME = "Mach3PendantServer";
    private final Logger l = LoggerFactory.getLogger(Mach3PendantServer.class);
    private Properties prop = new Properties();
    private static final String PROP_KEY_REMEMBERED_DEVICES = "remembered.devices";
    private Server tcpServer;
    private Server udpServer;
    private HandshakeListener handshakeListener = new HandshakeListener();
    private Robot robot;
    private List<Connection> authorizedConnections = new Vector<Connection>();
    private TrustedInterchangeListener trustedInterchangeListener = new TrustedInterchangeListener();
    private int prevHash = 0;
    private TrayIcon trayIcon;
    private boolean stopping = false;
    private User32 user32 = (User32)Native.loadLibrary("user32", User32.class);
    private byte[] windowText = new byte[512];
    private static final long DELAY_OF_REQUEST_NEW_WINDOW_TITLE = 10L;
    private PointerType hwnd;
    private static final int APP_VERSION = 101;
    private static final String MENU_LABEL_STATE = "State...";
    private static final String MENU_LABEL_EXIT = "Exit";
    private String tempPin;
    private List<String> rememberedDevices = new Vector<String>();
    private static final String MENU_LABEL_ABOUT = "About";

    public Mach3PendantServer() {
        SysOutOverSLF4J.sendSystemOutAndErrToSLF4J();
        this.l.info("Starting Mach3PendantServer 101");
        this.loadProperties();
        this.initTrayIcon();
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
            this.displayErrorMessage("Mach3PendantServer init problem", e.getMessage());
            this.onStop();
        }
        this.tcpServer = new Server();
        this.udpServer = new Server();
        Network.register(this.tcpServer);
        try {
            this.registerListeners();
            this.establishConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.displayErrorMessage("Mach3PendantServer init problem", e.getMessage());
            this.onStop();
        }
        this.startWindowChangeNotification();
    }

    private void loadProperties() {
        try {
            this.prop.load(new FileInputStream(propertiesFileName));
        }
        catch (IOException e) {
            this.releaseAllKeys();
            e.printStackTrace();
        }
        this.l.debug("load remembered devices");
        String rd = this.prop.getProperty(PROP_KEY_REMEMBERED_DEVICES, "");
        StringTokenizer st = new StringTokenizer(rd, ";");
        while (st.hasMoreTokens()) {
            String device = st.nextToken();
            this.l.debug("add " + device + " to the list of remembered devices");
            this.rememberedDevices.add(device);
        }
    }

    private void establishConnection() throws IOException {
        this.udpServer.start();
        this.udpServer.bind(54556, 54777);
        this.tcpServer.start();
        this.tcpServer.bind(54555);
    }

    private void registerListeners() {
        this.tcpServer.addListener(this.handshakeListener);
    }

    private void onStop() {
        this.stopping = true;
        this.tcpServer.stop();
        this.udpServer.stop();
        this.releaseAllKeys();
        this.saveProperties();
        System.exit(0);
    }

    private void saveProperties() {
        StringBuilder sb = new StringBuilder();
        for (String d : this.rememberedDevices) {
            sb.append(d).append(";");
        }
        this.prop.setProperty(PROP_KEY_REMEMBERED_DEVICES, sb.toString());
        try {
            this.prop.store(new FileOutputStream(propertiesFileName), "This is a Mach3PendantServer properties file");
        }
        catch (IOException e) {
            this.releaseAllKeys();
            e.printStackTrace();
        }
    }

    private void initTrayIcon() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            ActionListener exitListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Mach3PendantServer.this.onStop();
                }
            };
            PopupMenu popup = new PopupMenu();
            MenuItem state = new MenuItem(MENU_LABEL_STATE);
            popup.add(state);
            state.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringBuilder sb = new StringBuilder();
                    if (Mach3PendantServer.this.authorizedConnections.size() == 0) {
                        sb.append("You don't have any active connections");
                    } else {
                        sb.append("List of active connections:\n");
                    }
                    for (Connection con : Mach3PendantServer.this.authorizedConnections) {
                        if (!con.getRemoteAddressTCP().toString().contains("127.0.0.1")) {
                            sb.append("Wi-Fi: ");
                        }
                        sb.append(con.getRemoteAddressTCP()).append("\n");
                    }
                    JOptionPane.showMessageDialog(new Frame(), sb.toString(), "State", -1);
                }
            });
            popup.add(new MenuItem("-"));
            MenuItem about = new MenuItem("About...");
            popup.add(about);
            about.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(Mach3PendantServer.APP_NAME).append(" controls Mach3 by android devices running the Mach3Pendant application").append("\n");
                    sb.append("version ").append(101).append("\n");
                    sb.append("Created by raTMole").append("\n");
                    sb.append("ratmole@gmail.com");
                    JOptionPane.showMessageDialog(new Frame(), sb.toString(), Mach3PendantServer.MENU_LABEL_ABOUT, -1);
                }
            });
            popup.add(new MenuItem("-"));
            MenuItem exitItem = new MenuItem(MENU_LABEL_EXIT);
            exitItem.addActionListener(exitListener);
            popup.add(exitItem);
            this.trayIcon = new TrayIcon(this.createImage("/img/tray_icon_50.png", "tray icon"), APP_NAME, popup);
            this.trayIcon.setImageAutoSize(true);
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                this.releaseAllKeys();
                e.printStackTrace();
            }
        } else {
            this.l.error("System tray is currently not supported.");
        }
    }

    private void displayErrorMessage(String title, String message) {
        this.displayMessage(title, message, TrayIcon.MessageType.ERROR);
    }

    private void displayInfoMessage(String title, String message) {
        this.displayMessage(title, message, TrayIcon.MessageType.INFO);
    }

    private void displayMessage(String title, String message, TrayIcon.MessageType type) {
        if (this.trayIcon != null) {
            this.trayIcon.displayMessage(title, message, type);
        }
    }

    private void startWindowChangeNotification() {
        Thread notificationThread = new Thread(){

            @Override
            public void run() {
                while (!Mach3PendantServer.this.stopping) {
                    Mach3PendantServer.this.windowChangeNotification();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Mach3PendantServer.this.releaseAllKeys();
                        e.printStackTrace();
                    }
                }
            }
        };
        notificationThread.start();
    }

    private void windowChangeNotification() {
        ServerWindow msg = this.getCurrentServerWindow();
        int currHash = (String.valueOf(msg.getTitle()) + msg.getProcessName()).hashCode();
        if (currHash != this.prevHash) {
            this.prevHash = currHash;
            for (Connection con : this.authorizedConnections) {
                con.sendTCP(msg);
            }
        }
    }

    private ServerWindow getCurrentServerWindow() {
        this.hwnd = this.user32.GetForegroundWindow();
        this.user32.GetWindowTextA(this.hwnd, this.windowText, 512);
        String title = Native.toString(this.windowText);
        IntByReference p = new IntByReference();
        this.user32.GetWindowThreadProcessId(this.hwnd, p);
        int pid = p.getValue();
        String processName = this.getProcessNameByPid(pid);
        ServerWindow msg = new ServerWindow(title, processName);
        return msg;
    }

    private String getProcessNameByPid(int pid) {
        ProcessInfo[] pidTable;
        ProcessInfo[] processInfoArray = pidTable = new JavaSysMon().processTable();
        int n = pidTable.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfo info = processInfoArray[n2];
            if (info.getPid() == pid) {
                return info.getName();
            }
            ++n2;
        }
        return "";
    }

    private void runEventSequence(EventSequence sequence) {
        for (Event event : sequence.getSequence()) {
            if (!(event instanceof KeyEvent)) continue;
            KeyEvent keyEvent = (KeyEvent)event;
            if (keyEvent.press) {
                this.robot.keyPress(keyEvent.code);
                continue;
            }
            this.robot.keyRelease(keyEvent.code);
        }
    }

    protected Image createImage(String path, String description) {
        URL imageURL = Mach3PendantServer.class.getResource(path);
        if (imageURL == null) {
            this.l.error("Resource not found: " + path);
            return null;
        }
        return new ImageIcon(imageURL, description).getImage();
    }

    private String regeneratePin() {
        String time = Long.toString(System.currentTimeMillis());
        this.tempPin = time.substring(time.length() - 4);
        return this.tempPin;
    }

    public void releaseAllKeys() {
        for (String key : MapStringToKeyCode.map.keySet()) {
            if (this.robot == null) continue;
            this.robot.keyRelease(MapStringToKeyCode.map.get(key));
        }
    }

    public void finish() {
        this.releaseAllKeys();
    }

    public class HandshakeListener
    extends Listener {
        private String tempUserAccountName;
        private String tempUserAccountType;

        @Override
        public void received(Connection connection, Object object) {
            if (object instanceof Handshake) {
                Handshake h = (Handshake)object;
                switch (h.getId()) {
                    case 2: {
                        Mach3PendantServer.this.l.debug("Receive PHONE:TRUST_ME");
                        this.tempUserAccountName = h.getName();
                        this.tempUserAccountType = h.getType();
                        if (this.isAlreadyRememberedDevice()) {
                            this.finishAuthorization(connection);
                            break;
                        }
                        Mach3PendantServer.this.displayInfoMessage("", "Please enter PIN " + Mach3PendantServer.this.regeneratePin() + " on the Mach3Pendant client (" + this.tempUserAccountName + ")");
                        connection.sendTCP(new Handshake().pc_EnterPin());
                        break;
                    }
                    case 4: {
                        Mach3PendantServer.this.l.debug("Receive PHONE:SENT_PIN");
                        String pin = h.getPin();
                        Mach3PendantServer.this.l.debug("pin = " + pin);
                        if (pin.equals(Mach3PendantServer.this.tempPin)) {
                            this.finishAuthorization(connection);
                            if (!h.isRemember()) break;
                            this.rememberDevice();
                            break;
                        }
                        Mach3PendantServer.this.displayInfoMessage("", "Please enter PIN " + Mach3PendantServer.this.regeneratePin() + " on the Mach3Pendant client (" + this.tempUserAccountName + ")");
                        connection.sendTCP(new Handshake().pc_IncorrectPin());
                        break;
                    }
                }
            }
        }

        private void finishAuthorization(Connection con) {
            Mach3PendantServer.this.l.debug("Sent PC:I_TRUST_PHONE");
            con.sendTCP(new Handshake().pc_ITrustPhone());
            Mach3PendantServer.this.authorizedConnections.add(con);
            ServerGreeting greeting = new ServerGreeting();
            greeting.osName = System.getProperty("os.name");
            greeting.osVersion = System.getProperty("os.version");
            greeting.userName = System.getProperty("user.name");
            greeting.approvedByUser = true;
            greeting.serverWindow = Mach3PendantServer.this.getCurrentServerWindow();
            greeting.Mach3PendantServerVersion = 101;
            con.sendTCP(greeting);
            con.addListener(Mach3PendantServer.this.trustedInterchangeListener);
            if (!this.isAlreadyRememberedDevice()) {
                Mach3PendantServer.this.displayInfoMessage("Connection", "Mach3Pendant client has been connected");
            }
        }

        private void rememberDevice() {
            Mach3PendantServer.this.rememberedDevices.add(String.valueOf(this.tempUserAccountName) + "+" + this.tempUserAccountType);
        }

        private boolean isAlreadyRememberedDevice() {
            for (String d : Mach3PendantServer.this.rememberedDevices) {
                if (!d.equals(String.valueOf(this.tempUserAccountName) + "+" + this.tempUserAccountType)) continue;
                return true;
            }
            return false;
        }
    }

    private class TrustedInterchangeListener
    extends Listener {
        private TrustedInterchangeListener() {
        }

        @Override
        public void received(Connection connection, Object object) {
            if (object instanceof EventSequence) {
                Mach3PendantServer.this.runEventSequence((EventSequence)object);
            }
        }

        @Override
        public void disconnected(Connection connection) {
            Mach3PendantServer.this.displayInfoMessage("Connection", "Mach3Pendant client has been disconnected");
            Mach3PendantServer.this.releaseAllKeys();
        }
    }

    public static interface User32
    extends StdCallLibrary {
        public int GetWindowTextA(PointerType var1, byte[] var2, int var3);

        public WinDef.HWND GetForegroundWindow();

        public int GetWindowThreadProcessId(PointerType var1, IntByReference var2);
    }
}

