;line coded async output at ~115,200 baud
;each bit is 8.7uS @ 4MHz Tcyc = 1uS
;
;On entry byte is in TXBuff 
;txbit = GP5 
;
TxByte	BCF	INTCON,GIE	;DISABLE INTERRUPTS
	BCF	GPIO,Txbit	;start bit out
	nop
	nop
	nop
	nop
	movf	GPIO,w
	andlw	0xDF		;clear bit 5
	BTFSC	TXBuff,0
	iorlw	0x20		;set bit
	movwf	GPIO		;************** bit 0
	nop
	nop
	nop
	nop
	movf	GPIO,w
	andlw	0xDF		;clear bit 5
	BTFSC	TXBuff,1
	iorlw	0x20		;set bit
	movwf	GPIO		;************** bit 1
	nop
	nop
	nop
	nop
	movf	GPIO,w
	andlw	0xDF		;clear bit 5
	BTFSC	TXBuff,2
	iorlw	0x20		;set bit
	movwf	GPIO		;************** bit 2
	;nop
	nop
	nop
	nop
	movf	GPIO,w
	andlw	0xDF		;clear bit 5
	BTFSC	TXBuff,3
	iorlw	0x20		;set bit
	movwf	GPIO		;************** bit 3
	nop
	nop
	nop
	nop
	movf	GPIO,w
	andlw	0xDF		;clear bit 5
	BTFSC	TXBuff,4
	iorlw	0x20		;set bit
	movwf	GPIO		;************** bit 4
	nop
	nop
	nop
	nop
	movf	GPIO,w
	andlw	0xDF		;clear bit 5
	BTFSC	TXBuff,5
	iorlw	0x20		;set bit
	movwf	GPIO		;************** bit 5
	nop
	;nop
	nop
	nop
	movf	GPIO,w
	andlw	0xDF		;clear bit 5
	BTFSC	TXBuff,6
	iorlw	0x20		;set bit
	movwf	GPIO		;************** bit 6
	nop
	nop
	nop
	nop
	movf	GPIO,w
	andlw	0xDF		;clear bit 5
	BTFSC	TXBuff,7
	iorlw	0x20		;set bit
	movwf	GPIO		;************** bit 7
	nop
	nop
	nop
	nop
	nop
	nop
	BSF	GPIO,TxBit 	;stop bit
	bcf	intcon,GPIF	;clear bit changed flag
	BSF	INTCON,GIE	;RE ENABLE INTERUPTS
	RETURN
;---------------------------------------------------------------
;Async receive routine
;called from port bit changed interrupt
;line coded for accuracy @ 115,200 baud
;input is inverted i.e. +ve = 0
;
;Optimised for two byte sequencial reception
;
RxByte	CLRF	RxBuff+1
	BTFSS	GPIO,Rxbit	;test bit 0 - must be 13uS after interrupt
	BSF	RxBuff+1,0
	nop
	nop
	nop
	nop
	nop
	nop
	BTFSS	GPIO,Rxbit	;test bit 1 
	BSF	RxBuff+1,1
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	BTFSS	GPIO,Rxbit	;test bit 2 
	BSF	RxBuff+1,2
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	BTFSS	GPIO,Rxbit	;test bit 3 
	BSF	RxBuff+1,3
	nop
	nop
	nop
	nop
	nop
	nop
	BTFSS	GPIO,Rxbit	;test bit 4 
	BSF	RxBuff+1,4
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	BTFSS	GPIO,Rxbit	;test bit 5
	BSF	RxBuff+1,5
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	BTFSS	GPIO,Rxbit	;test bit 6 
	BSF	RxBuff+1,6
	nop
	nop
	nop
	nop
	nop
	nop
	BTFSS	GPIO,Rxbit	;test bit 7 
	BSF	RxBuff+1,7
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	BTFSC	GPIO,Rxbit	;test framing
	goto	rxdoFE
	BTFSS	RxState,rxSB
	GOTO	rxdoFBR
	nop
	nop
	nop
	nop
tfinb	nop
	BTFSS	GPIO,Rxbit	;test for immediate next byte
	goto	rxSBR
;	nop
;	nop
;	nop
;	nop
;	nop
	nop
	nop
	nop
	goto	RXByte		;get next byte
;
rxSBR	btfss	rxstate,rxSB
	return
	MOVLW	0x80		;second byte received OK
	MOVWF	RxState
	RETURN
;
rxdoFBR	BSF	Rxstate,rxSB	;set next byte pointer
	movf	RxBuff+1,w
	movwf	RXBuff		;save first byte
	goto	tfinb
;
rxdoFE	MOVLW	0x10		;flag frame error and reset pointers
	MOVWF	Rxstate
	RETURN

;=========================Serial utilities==========================
;---------------------------
;transmit negative acknowledge (error)
txNACK	movlw	0x15
	movwf	txBuff
	clrf	rxstate
	goto	txbyte
;
;transmit acknowledge 
txACK	movlw	0x06
	movwf	txBuff
	goto	txbyte

;---------------------------------
;transmit W as two hex digits
;uses:
;temp

TxWhex	movwf	temp		;save
	swapf	temp,w
	call	txmsn
	movf	temp,w
txmsn	andlw	0x0F
	movwf	txbuff		;save ms nibble
	sublw	0x09
	movlw	0x30
	btfss	status,c
	movlw	0x37
	addwf	txbuff,f
	call	txbyte
	return	
;tx CRLF
TxCRLF	movlw	0x0d
	movwf	txbuff
	call	txbyte
	movlw	0x0a
	movwf	txbuff
	call	txbyte
	return
