;Vernier project (c) W.K.Todd 2005
;V-2.2 12/08/2007 - includes Vernier ID output
;RS232 interface @ 115,200 baud, 8 bit, no parity, 1 stop bit
;115,200 baud  = 8.7uS
;
;Memory allocation bytes

Rxbuff		EQU 	0x20 	;receive buffer 2 bytes
RxState		EQU	0x22
TxBuff		EQU	0x23	;transmit buffer (used as temp in some routines)
Temp		EQU	0x24
Mode		EQU	0x25	;current vernier mode
Vdata		equ	0x26	;4 bytes shift register (for newer verniers)
				;Vdata = MSByte  or New vernier flags
				;Vdata+1 = NSB or MS digits 6&5
				;Vdata+2 = LSbyte or digits 4&3
				;Vdata+3 = digits 2&1
IDbyte		EQU	0x2A	;W,X,Y,Z identity (set by id check)

wsave  		EQU     0x5E   	;SAFE STORAGE FOR W DURING INTERRUPTS
stsave   	EQU     0x5F   	;SAFE STORAGE FOR STATUS BITS 

;Bits
;Mode flags
Auto		EQU	0x00		;auto - enable tx
Fast		EQU	0x01		;fast read
Fflg		EQU	0x02		;fast flag used by measure routine
VCFlg		EQU	0x03		;verier connected flag

;New Vernier flags
SignBit		EQU	0x04		;1 =-ve
HalfThou	EQU	0x05		;1 = 0.0005"
MMInch		EQU	0x06		;1 = mm
Vtype		EQU	0x07		;vernier type flag: 1 = new Decimal 4bit digit

;RxState - serial port flags
RxOK		EQU	0x07		;two bytes recieved
RxFE		EQU	0x04		;frame error
RxSB		EQU	0x00		;rx second byte
Echo		EQU	0x00		;ECHO FLAG BIT

;GPIO pins
VDP		EQU	0x00		;GP0 - Vernier data input (Mode switch)
VCP		EQU	0x01		;GP1 - Vernier Clock input (Zero switch
IdBit		EQU	0x02		;GP2 - Identity input for DRO board
RxBit		EQU	0x03		;GP3 - RS232 input direct from RxD (input only)
TxSyn		EQU	0x04	 	;GP4 - tx sync (for multiple axes)
TxBit		EQU	0x05	 	;GP5 - RS232 output to transistor base


;=================================== START ==================================
;
;
		LIST   P=PIC12F675
		#include <p12f675.inc>

		errorlevel  -302              ; suppress message 302 from list file

		__CONFIG   _CP_OFF & _CPD_OFF & _BODEN_ON & _MCLRE_OFF & _WDT_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT 

		;ORG	0x1FF		
		;GOTO	START		;second page reset vector

		ORG     0x000   
		GOTO    START           ;RESET VECTOR
		NOP
		NOP     
		NOP
;--------------------------- INTERRUPT VECTORS TO HERE ----------------------------
;
isrvect		movwf   wsave       	;Save W
        	swapf   STATUS,w    	;swap status into W
        	bcf     STATUS,RP0  	;select bank 0
        	movwf   stsave      	;save swapped status
;----------Interrupt service routine----------------
		btfsc	INTCON,GPIF
		call	RxByte
		movf	GPIO,w		;read GPIO to reset IOC bits
		bcf	INTCON,GPIF	;clear interrupt flag
;----------------------------------------------
isrexit 	swapf   stsave,w    	;restore status into W
        	movwf   STATUS      	;then into status
        	swapf   wsave,f
        	swapf   wsave,w     	;restore W without changing status
        	retfie              	;return from interrupt
        
;-------------------------------------------------------------------------------
;tables go here
		#include <message table.asm>


;---------------------------------- Initialise ---------------------------------
START		BSF	status,RP0	;select bank 1
;intialise bank 1 registers 
		movlw	B'00111111'	;GP0-5 in, (GP5 o/p switched by async routine)
		movwf	trisio
		movlw	B'00110000'	;enable weak pull up on GP4(TXsyn) and GP5 TXD
		movwf	WPU
		movlw	B'00001110'	;set options reg PSA=1 WDT*64=1158mS
		movwf	OPTION_REG
		movlw	B'00001000'	;Interupt On Change Bits GP3-RXBIT
		movwf	IOCB
		movlw	B'00000000'	;ANSEL Fosc/8
		movwf	ANSEL
		call	0x3ff		
		movwf	OSCCAL		;calibrate oscilator
;initialise bank 0 registers 
		BCF	status,RP0	;select bank 0
		clrf	ADCON0		;disable adc
		call	ChkID		;check ID (w,x,y,z)
		movlw	B'00001000'	;enable WPU, IOC
		movwf	INTCON		;
;variable initialise
		clrwdt
		BSF	GPIO,TxBit	;clear the rx bit
		bsf	GPIO,TXsyn	;enable WPU on sync output
		call	Vinit		;initialise Vernier reading routines
		btfsc	Mode,VCFlg	;check if previously connected
		call	txDiscon	;transmit disconnect signal

		call	GetVT		;determine Vernier type (watchdog trap)
		clrf	rxstate
;test reset source
		btfss	PCON,NOT_POR
		bsf	PCON,NOT_BOD	;reset Brown out detector flag
		btfss	PCON,NOT_BOD
		NOP			;Do brown out reset
		bsf	PCON,NOT_BOD	;reset Brown out detector flag
		btfss	PCON,NOT_POR
		clrf	Mode		;power on reset
		;>>>			;watchdog reset	
		
		
		call	GetVT		;determine Vernier type
		clrwdt
		call	Zeronorm	;zero the vernier
		call	txConnct	;send connected message
		call	txZero		;send zeroed message
		bsf	INTCON,GIE	;enable interrupts
		
;------------------------------ main loop ------------------------------
Mainlp		clrwdt			;clear watchdog
		btfsc	rxstate,rxFE
		call	txNACK		;tranmits NACK if rx error
		btfsc	rxstate,rxok	;if command received...
		CALL	command		;do command
		btfsc	Mode,Auto	;test if auto mode is enabled...
		call	readX		;if so, tx data
		GOTO 	Mainlp
;---------------------------------------------------------------------


;======================= Subroutines ===================================

;command line interpretor
;Commands: (case insensitive)
;rx - Read - reads and transmits abs position (x=x,y,z,w)
;sn - Sets sample rate (n=0,1,2) 0 =poll mode, 1 = 300mS (normal), 2 = 20mS (fast mode)
;zx - zero vernier display (x=x,y,z,w)
;vn - set vernier type (n=0,1) 0 = old, 1=decimal
command		
docmd		clrf	rxstate
;
		movf	rxbuff,w
		andlw	0xDF
		xorlw	'R'		;Read now (tx current pos)
		btfsc	status,z
		goto	testX

		movf	rxbuff,w
		andlw	0xDF
		xorlw	'S'		;Sample Period 0 = poll
		btfsc	status,z
		goto	setSP

		movf	rxbuff,w
		andlw	0xDF
		xorlw	'Z'		;Zero vernier display
		btfsc	status,z
		goto	Zero

		movf	rxbuff,w
		andlw	0xDF
		xorlw	'V'		;set vernier type
		btfsc	status,z
		goto	setVT
		
		movf	rxbuff,w
		andlw	0xDF
		xorlw	'I'		;request info string
		btfsc	status,z
		goto	txInfo		
		
		return

;set vernier type from serial port
setVT		btfsc	rxbuff+1,1	;3 = read type
		goto	GetVT	
		bcf	Mode,Vtype
		btfsc	rxbuff+1,0	;0 = old, 1=decimal
		bsf	Mode,Vtype	
		return

;rx - Read - reads and transmits position
testX		movf	rxbuff+1,w
		andlw	0xDF
		xorwf	IDbyte,w	;test correct axis 
		btfss	status,z
		return
readX		call	getvd		;read data from vernier
		call	WaitBus		;sync txd 
		btfsc	Mode,Vtype
		call	txdec		;transmit decimal string
		btfss	Mode,Vtype
		call	TxHex		;transmit Hex string
		;goto	RelBus

;Serial Bus arbitration routines
;release bus
RelBus		BSF	status,RP0	;select bank 1
		BSF	trisio,TxBit	;TXbit HiZ
		BSF	trisio,Txsyn	;txsyn HiZ
		BCF	status,RP0	;select bank 0	
		BSF	GPIO,Txsyn	;txsyn hi	
		return
;Wait to grab bus
WaitBus		btfss	GPIO,Txsyn
		goto	WaitBus
 		movf	IDbyte,w	;get WXYZ 0x57 - 0x5a
		sublw	0x5B		;reduce to 1 - 4
		movwf	temp		;delay
toglp1		decfsz	temp,f
		goto	toglp1	
		btfss	GPIO,Txsyn		
		goto 	WaitBus
		BSF	status,RP0	;select bank 1
		BCF	trisio,Txsyn	;txsyn low
		BCF	trisio,TxBit	;TXBit output
		BCF	status,RP0	;select bank 0
		BCF	GPIO,Txsyn	;txsyn low
		RETURN
	
;transmit hex string new version XH000000: (old e.g &H000000X)
TxHex		movf	IDbyte,w	;start tx with IDbyte W,X,Y,Z
		;movlw	'&'
		call	TxW		;transmit hex string prefix
		movlw	'H'
		call	TxW
		movf	Vdata,w
		call	TxWhex		;tx data as hex digits
		movf	Vdata+1,w
		call	TxWhex		
		movf	Vdata+2,w
		call	TxWhex		
txterm		;movf	IDbyte,w	;terminate tx with IDbyte W,X,Y,Z
		movlw	':'
		
TxW		movwf	TXBuff
		goto	TXByte

;transmit decimal string e.g.  X+00.0000: (old +00.0000X (inch) or +000.00mX (mm))
txdec		movf	IDbyte,w	;start tx with IDbyte W,X,Y,Z
		call	TxW		;transmit hex string prefix
		movlw	'+'
		btfsc	Vdata,signbit	
		movlw	'-'
		call	TxW
		movf	Vdata+1,w	;tx digits 5 & 4
		call	TxWhex
		btfsc	Vdata,mminch
		goto	txdecmm		;tx mm
		movlw	'.'
		call	TxW
		movf	Vdata+2,w	;tx digits 3 & 2
		call	TxWHex
		swapf	Vdata+3,w	;tx digit 1
		call	Txmsn		;tx significant nibble only
		movlw	'0'
		btfsc	Vdata,HalfThou
		movlw	'5'
		call	TxW		;tx halfthou digit
		goto 	txterm
txdecmm		swapf	Vdata+2,w	;tx digit 3 	
		call	Txmsn		
		movlw	'.'
		call	TxW
		movf	Vdata+2,w	;tx digit 2 	
		call	Txmsn			
		swapf	Vdata+3,w	;tx digit 1
		call	Txmsn		;tx significant nibble only
		;movlw	'm'		;indicate metric
		;call	TxW
		goto	txterm
		
;tx significant nibble only		
TxLsn		

;sx - Sets sample period x: 0 =poll mode, 1 = 300mS, 2 = 20mS  fast
setSP		;call	getVT		;get verniertype
		movf	rxbuff+1,w
		andlw	0x03
		movwf	rxbuff+1
		btfsc	status,z
		goto	setPoll
		btfsc	rxbuff+1,0
		goto	setSaut		;set slow auto mode
		btfsc	rxbuff+1,1
		goto	setFaut		;set fast auto mode
		return

setPoll		bcf	Mode,Auto
		return

;because speed is set by toggling Dataline we have to measure vernier reading
;speed before togging speed.
;
setSaut		bsf	Mode,Auto
setSlow		bcf	Mode,Fast	;clear fast
		clrwdt
		call	zeronorm
		call	txZero		;send Zero message
		return		


setFaut		bsf	Mode,Auto
setFast		bsf	Mode,Fast
		clrwdt
		call	zeronorm
		clrwdt			;pulse clk again if decimal type
		call	Dly200
		call	Plsdata
		btfss	Mode,Vtype 
		return
		clrwdt			;pulse clk again if decimal type
		call	Dly200
		call	Plsclk
		call	txZero		;send zero message
		return


;200msDelay	
Dly200		movlw	0x55
		movwf	txbuff		;50ms
		clrf	temp
		call	toglp
;150ms delay
Dly150 		clrf	temp
		clrf	txbuff		;borrow txbuff as a counter
toglp		decfsz	temp,f
		goto	toglp
		decfsz	txbuff,f
		goto	toglp
		return


;Zero vernier display 
Zero		movf	rxbuff+1,w
		andlw	0xDF
		xorwf	IDbyte,w	;test correct axis 
		btfss	status,z
		return

		call	zeronorm
		btfss	Mode,Fast	;if it was in fast mode then setfast
		return
		goto	setFast
		
;set zero normal mode		
ZeroNorm	call	measure		
		btfss	Mode,Fflg
		goto	tstslow
pdlp		call	PlsData		;pulse data until slow
		call	measure
		btfsc	Mode,Fflg	;test slow		
		goto	pdlp
		call 	PlsClk		;pulse clk (zero switch)
		return

				
Tstslow		call 	PlsClk		;pulse clk
		call	measure		
		btfsc	Mode,Fflg	;test slow	
		goto	pdlp		;if fast, pulse data until slow	
		return			;normal zero

		
;pulse clock		
PlsClk		bcf	status,RP0	;select back 0
		bsf	GPIO,VCP	;set port hi
		bsf	status,RP0	;select bank 1
		bcf	trisio,VCP	;GP1 = output
		clrwdt
		call	dly200		;200mS delay
		bsf	trisio,VCP	;GP1 = input
		bcf	status,RP0	;select back 0			
		return
;pulse data		
PlsData		bcf	status,RP0	;select back 0
		bsf	GPIO,VDP	;set port hi
		bsf	status,RP0	;select bank 1
		bcf	trisio,VDP	;GP1 = output
		clrwdt
		call	dly200		;200mS delay
		bsf	trisio,VDP	;GP1 = input
		bcf	status,RP0	;select back 0			
		return	

;------------------------------------------------
;vernier info routines
txZero		call 	WaitBus		;transmit Reset signal
		movlw	'R'		;tx 'Rx' for zeRoed (can't use Z)
		call	TxW
		movf	IdByte,w
		call	TxW
		call	txterm		;send : terminator			
		call	RelBus
		return

txDiscon	call 	WaitBus		;transmit disconnect signal
		movlw	'D'		;D for disconnect
		call	TxW
		movf	IdByte,w
		call	TxW
		call	txterm		;send : terminator			
		call	RelBus
		bcf	Mode,VCFlg	;clear the connected flag
		return

txConnct	call	WaitBus		;transmit connected signal
		movlw	'C'		;C for connect
		call	TxW
		movf	IdByte,w
		call	TxW
		call	txterm		;send :			
		call	RelBus
		bsf	Mode,VCFlg	;set the connected flag
		return
		
txInfo		call	WaitBus		;transmit info string
		movlw	'I'
		call	TxW
		movf	IdByte,w
		call	TxW	
		call	txsep		;tx separator ","
		movf	Mode,w
		andlw	0x03
		iorlw	0x30
		call	TxW
		call	txsep		;tx separator ","	
		movlw	DecMSG		;decimal message pointer
		btfss	Mode,Vtype
		movlw	BinMSG
		call	TxMSGW		
		movlw	MmMSG
		btfss	Mode,MMInch
		movlw	InchMSG
		call	TxMSGW			
		call	txterm
		call	RelBus
		return
		
txsep		movlw	','
		goto	TxW
;-----------------------------------------------------
;check indentity (for DRO board)
;returns X,Y,Z or W depending on state of IDpin
;gnd = X
;GP0 = Y (connected to GP0)
;GP1 = Z
;GP4(wpu high) = W

ChkID		movlw	'Y'	;0x59
		bcf	GPIO,VDP	;set port low (test Y)
		bsf	status,RP0	;select bank 1
		bcf	trisio,VDP	;GP0 = output	
		bcf	trisio,VCP	;GP1 = output
		bcf	status,RP0	;bank 0
		btfsc	GPIO,IDbit	;test ID pin input
		goto	NotY
		bsf	GPIO,VDP	;set bit high
		nop
		btfsc 	GPIO,IDbit
		goto 	ChkXit

NotY		movlw	'Z'	;0x5A
		bcf	GPIO,VCP	;set port low (test Z)
		btfsc	GPIO,IDbit	;test ID pin input
		goto	NotZ
		bsf	GPIO,VCP
		nop
		btfsc	GPIO,IDbit
		goto 	ChkXit

NotZ		movlw	'X'	;0x58
		bsf	GPIO,TxSyn	;test W
		nop
		btfsc	GPIO,IDbit
		movlw	'W'	;0x57
chkxit		movwf	IDbyte		;set identity		
		bsf	status,RP0	;select bank 1
		bsf	trisio,VDP	;GP0 = input	
		bsf	trisio,VCP	;GP1 = input
		bcf	status,RP0	;bank 0	
		return

;-------------------------------Includes---------------------------
		#include <serial.asm>
		#include <syncserial1.asm>
;================================= END =============================
		END
;===================================================================
