#include "globals.h"
#include "display.h"
#include "lcd.h"

void	LCDPutChar(u8 c)
{
	LCD_RS = 1;
	LCDWriteByte(c);
}

// leading zero flag
u8		lz;

u16		LCDDivAndWrite(u16 num, u16 div)
{
	u8	tmp;
	tmp = num / div;
	num -= tmp * div;
	
	if (!tmp && lz)
		LCDWriteByte(' ');
	else
	{
		LCDWriteByte(tmp + '0');
		lz = 0;
	}
	return num;
}

// write a u16, of digs digits, LZ is leading zero flag
void	LCDWriteU16(u16 num, u8 digs, u8 LZ)
{
	lz = LZ;
	LCD_RS = 1;
	
	if (digs > 4) num = LCDDivAndWrite(num, 10000);
	if (digs > 3) num = LCDDivAndWrite(num, 1000);
	if (digs > 2) num = LCDDivAndWrite(num, 100);
	if (digs > 1) num = LCDDivAndWrite(num, 10);
	lz = 	0;
	LCDDivAndWrite(num, 1);	
}


// write an s16, of digs digits, LZ is leading zero flag
void	LCDWriteS16(s16 num, u8 digs, u8 LZ)
{
	lz = LZ;
	LCD_RS = 1;
	
	if (num < 0)
	{
		LCDWriteByte('-');
		num = -num;
	}
	
	if (digs > 4) num = LCDDivAndWrite(num, 10000);
	if (digs > 3) num = LCDDivAndWrite(num, 1000);
	if (digs > 2) num = LCDDivAndWrite(num, 100);
	if (digs > 1) num = LCDDivAndWrite(num, 10);
	lz = 	0;
	LCDDivAndWrite(num, 1);	
}


void	LCDWriteDecimal(u8 num)
{
	LCDWriteS16(num, 3, 1);
}


#ifdef LARGENUMBERS
s16		LCDDivAndWriteLarge(s16 num, s16 div, u8 col)
{
	u8	tmp;
	tmp = num / div;
	num -= tmp * div;
	
	if (!tmp && lz)
		PrintLargeNumber(11, col);	// space
	else
	{
		PrintLargeNumber(tmp, col);
		lz = 0;
	}
	return num;
}

// write an s16, of digs digits, LZ is leading zero flag
void	LCDWriteS16Large(s16 num, u8 digs, u8 LZ, u8 col)
{
	int	i;
	lz = LZ;
	LCD_RS = 1;
	
	if (num < 0)
	{
		for (i = 0; i < digs; i++)
		{
			PrintLargeNumber(10, col);
			col+= 3;
		}
	}
	else
	{
		if (digs > 4) {num = LCDDivAndWriteLarge(num, 10000, col); col += 3;}
		if (digs > 3) {num = LCDDivAndWriteLarge(num, 1000, col); col += 3; }
		if (digs > 2) {num = LCDDivAndWriteLarge(num, 100, col); col += 3; }
		if (digs > 1) {num = LCDDivAndWriteLarge(num, 10, col); col += 3; }
		lz = 	0;
		LCDDivAndWriteLarge(num, 1, col);	
	}
}

#endif

#ifdef	FLOATS
void	LCDWriteFloat(float f, u8 numdigs)
{
	float	tmp;
	int		div;
	u8		n;

	LCD_RS = 1;	// write characters
	
	tmp = f;
	div = 1;
	
	if (tmp < 0.f)
	{
		LCDWriteByte('-');
		tmp = -tmp;
	}
	
	while(tmp > 10.f)
	{
		div++;
		tmp = tmp/10.f;
	}
	
	while(div)
	{
		n = (u8) tmp;
		LCDWriteByte(n + '0');
		tmp -= (float) n;
		tmp *= 10.f;
		div--;
	}
	
	LCDWriteByte('.');
	
	while(numdigs)
	{
		n = (u8) tmp;
		LCDWriteByte(n + '0');
		tmp -= (float) n;
		tmp *= 10.f;
		numdigs--;
	}
}
#endif

