#include <pic18.h>

#define u8	unsigned char
#define s8	signed char
#define u16	unsigned short
#define	s16	signed short
#define u32	unsigned long
#define s32	signed long

#define	true	1
#define	false	0

#define PORTBIT(adr, bit) ((unsigned)(&adr)*8+(bit))

//------------------------
typedef struct
{
	u8	L;
	u8	H;
} HL8;

typedef	union
{
	u16	U16;
	HL8	U8;
} HL16;

typedef struct
{
	u16	L;
	u16	H;
}HL32;

typedef struct
{
	s16	L;
	s16	H;
}HLS32;

// fixed point union 16.16
typedef union
{
	HLS32	S16;
	HL32	U16;
	u8		U8[4];
	u32		U32;
	s32		S32;
}fp32;
