#ifndef	_KEYPAD_H_
#define	_KEYPAD_H_

void	ScanKeypad(void);
u8		GetKeyASCII(void);

extern u8	KeyASCII, DebouncedKeyASCII;

extern u16	EditNumber(u8 line, u8 pos, u8 maxdigits, u16 initial, u8 dp);
extern int	gEditCancelled;	// true if user pressed cancel.

// key defines
#define	KEYSTOP		'X'
#define	KEYOK		'O'
#define	KEYSPEED	'S'
#define	KEYCLR		'C'
#define	KEYPREV		'P'
#define	KEYNEXT		'N'
#define	KEYZERO		'0'
#define	KEYONE		'1'
#define	KEYTWO		'2'
#define	KEYTHREE	'3'
#define	KEYFOUR		'4'
#define	KEYFIVE		'5'
#define	KEYSIX		'6'
#define	KEYSEVEN	'7'
#define	KEYEIGHT	'8'
#define	KEYNINE		'9'


// keypad keys are mapped here

#define	NOKEY		0
#define	KEYR4C1		KEYONE		// 1 abc
#define	KEYR3C1		KEYFOUR		// 4 jkl
#define	KEYR2C1		KEYSEVEN	// 7 stu
#define	KEYR1C1		KEYPREV		// prev

#define	KEYR4C2		KEYTWO		// 2 def
#define	KEYR3C2		KEYFIVE		// 5 mno
#define	KEYR2C2		KEYEIGHT	// 8 vwx
#define	KEYR1C2		KEYZERO		// 0

#define	KEYR4C3		KEYTHREE	// 3 ghi
#define	KEYR3C3		KEYSIX		// 6 pqr
#define	KEYR2C3		KEYNINE		// 9 yz
#define	KEYR1C3		KEYNEXT		// next

#define	KEYR4C4		KEYSPEED	// speed
#define	KEYR3C4		KEYSTOP		// stop
#define	KEYR2C4		KEYOK		// OK
#define	KEYR1C4		KEYCLR		// cancel

#endif
