/*
 *	LCD interface header file
 *	See lcd.c for more info
 */

//#define	LARGENUMBERS

#define LCDWIDTH	20

// lcd sits on top nibble of this port.
#define	LCDPORT	PORTB

static bit LCD_RS	@ PORTBIT(LCDPORT, 0);		// Register select
static bit LCD_EN	@ PORTBIT(LCDPORT, 1);

// debug string printer...
#define	DTXT(x)	LCDGoto(0,0); LCDPuts(x);

/* write a byte to the LCD in 4 bit mode */
extern void LCDWriteByte(unsigned char);

/* Clear and home the LCD */
extern void LCDClear(void);

/* clear num chars on line starting at col */
extern void	LCDClearLine(u8 line, u8 col, u8 num);

/* write a string of characters to the LCD */
extern void LCDPuts(const char * s);

/* Go to the specified position */
extern void LCDGoto(unsigned char line, unsigned char pos);
	
/* intialize the LCD - call before anything else */
extern void LCDInit(void);

extern void LCDPutch(char);

/*	Set the cursor position */
#define	LCDCursor(x)	lcd_write(((x)&0x7F)|0x80)

#define	LCDCurserOn			{LCD_RS = 0; LCDWriteByte(0xe);}
#define LCDCurserFlash		{LCD_RS = 0; LCDWriteByte(0xf);}
#define	LCDCurserOff		{LCD_RS = 0; LCDWriteByte(0xc);}


// large number defs
#ifdef LARGENUMBERS
	extern void	InitLargeNumbers();
	extern void	PrintLargeNumber(u8 num, u8 col);
#endif


