#ifndef	_MAIN_H_
#define	_MAIN_H_

//------------------------
// stepper

static bit	DirectionOut	@ PORTBIT(PORTC, 0);
static bit	DirectionTris	@ PORTBIT(TRISC, 0);

static bit	StepOut			@ PORTBIT(PORTC, 7); //v1.1
static bit	StepTris		@ PORTBIT(TRISC, 7);

//static bit	StepOut			@ PORTBIT(PORTC, 1);	// v1.0
//static bit	StepTris		@ PORTBIT(TRISC, 1);

static bit	ActiveOut		@ PORTBIT(PORTC, 3);	// 1 when active
static bit	ActiveTris		@ PORTBIT(TRISC, 3);

static bit	CCPIn			@ PORTBIT(PORTC, 1);
static bit	CCPTris			@ PORTBIT(TRISC, 1);

static bit	SenseIn			@ PORTBIT(PORTA, 0);	// normally low
static bit	SenseTris		@ PORTBIT(TRISA, 0);

static bit	AckOut			@ PORTBIT(PORTA, 1);	// normally open
static bit	AckTris			@ PORTBIT(TRISA, 1);

static bit	Limit1In		@ PORTBIT(PORTA, 5);	// normally high
static bit	Limit1Tris		@ PORTBIT(TRISA, 5);

static bit	Limit2In		@ PORTBIT(PORTE, 0);	// normally high
static bit	Limit2Tris		@ PORTBIT(TRISE, 0);

static bit	SounderOut		@ PORTBIT(PORTB, 3);
static bit	SounderTris		@ PORTBIT(TRISB, 3);

//------------------------
// exported functions
void	EEWrite(u8 addr, u8 data);	// write to eeprom
u8		EERead(u8 addr);			// read from eeprom

void	WriteSPI(u8 tx);
u8		ReadSPI(u8 tx);

void	Beep(int freq, int dur);

//------------------------
// exported vars
extern u8	Mode;
extern int	gTimerCount;	// 100mS timer
extern int	gProcessTimer;
extern int	gComplete;		// true if table at destination

extern u16	gStepRate;
extern u16	gStepRateMax;
extern u16	gStepRateRamp;
extern volatile u32	gSteps;			// total steps to take
extern u16	gAccelSteps;	// number of steps we'll accelerate for
extern u16	gDecelSteps;	// number of steps we'll decelerate for

extern u16	gStepsNextInt;
extern int	gNoPrescaler;


//------------------------
// Current mode.
enum
{
	GREETING,
	SELECTGAME,
	WAITGREET,
	BEGINTABLE,
	PROCESSTABLE,
	
	NUMMODES
};


#endif

