VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} MiniGcode 
   Caption         =   "MiniGcodeGenerator V1.6"
   ClientHeight    =   11310
   ClientLeft      =   45
   ClientTop       =   390
   ClientWidth     =   11760
   OleObjectBlob   =   "MiniGcode.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "MiniGcode"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub Enter_Excel_Click()

' Button on form which allows user to make Excel workbooks visible to get back in to view code etc.
Application.ScreenUpdating = True
Application.Visible = True

End Sub

Private Sub UserForm_Terminate()

' When form closes quit Excel, otherwise it is kept open 'by another user' in the background
Application.Quit
  
End Sub


Private Sub UserForm_Initialize()
'''' set up initial variables when form first run

' initialise variables (mm)
    With Me
        ' Circle tab
        .InsideCircleContour.Value = True
        .InsidePocket.Value = False
        .PocketStepOverPercent.Value = 30
        .ToolDia.Value = 6
        .HoleX = 0
        .HoleY = 0
        .HoleZ = 0
        .Start_Offset_Z = 0.1
        .CircleDia = 10
        .CircleDepth = 3
        .RadialStockToLeave.Value = 0
        .IncludeFinishPass.Value = False
        .FeedPlunge = 100
        .StepDown = 1
        .FeedCutting = 200
        .SpindleSpeed = 12000
        
        ' Save path and file name defaults
        .My_Path_Name = "C:\Users\inbox\Desktop\"
        .My_File_Name = "MiniGcode"
    
    End With

End Sub

Private Sub Generate_GCode_Circle_Click()

'''' Initialise variables
Dim LoopCounter As Integer
Dim Tool_PathRadius As Double
Dim Tool_Xstart As Double
Dim Tool_Ystart As Double
Dim Tool_Zstart As Double
Dim Tool_Zfinish As Double
Dim Tool_Xend As Double
Dim Tool_Zcurrent As Double
Dim Line_Counter As Integer
Dim Number_Of_Loops As Double
Dim Circle_Bottom As Double
Dim Read_CircleType As Integer
Dim Read_ToolDia As Double
Dim Read_HoleX As Double
Dim Read_HoleY As Double
Dim Read_HoleZ As Double
Dim Read_Start_Offset_Z As Double
Dim Read_CircleDia As Double
Dim Read_CircleDepth As Double
Dim Read_RadialStockToLeave As Double
Dim Read_IncludeFinishPass As Boolean
Dim Read_FeedPlunge As Integer
Dim Read_StepDown As Double
Dim Read_FeedCutting As Integer
Dim Read_Spindle_Speed As Integer
Dim Read_My_Path_Name As String
Dim Read_My_File_Name As String
Dim ValidToolPath As Integer
Dim InitialFinishCutting As Integer
Dim Reached_RoughingRadius As Boolean
Dim Read_PocketStepOverPercent As Integer
    
'''' Read values from user form
Read_CircleType = Select_Circle_Type.InsideCircleContour ' -1 = inside circle, 0 = full inside pocket
Read_PocketStepOverPercent = PocketStepOverPercent.Value
Read_ToolDia = ToolDia.Value
Read_HoleX = HoleX.Value
Read_HoleY = HoleY.Value
Read_HoleZ = HoleZ.Value
Read_Start_Offset_Z = Start_Offset_Z
Read_CircleDia = CircleDia.Value
Read_CircleDepth = CircleDepth.Value
Read_RadialStockToLeave = RadialStockToLeave.Value
Read_IncludeFinishPass = IncludeFinishPass.Value
Read_FeedPlunge = FeedPlunge.Value
Read_StepDown = StepDown.Value
Read_FeedCutting = FeedCutting.Value
Read_Spindle_Speed = SpindleSpeed
Read_My_Path_Name = My_Path_Name.Value
Read_My_File_Name = My_File_Name.Value

'''' GCODE INITIALISATION ***************************************************************
' Reset warning message
Warning.Value = ""

' Flag for outcome of code generation 0 = code is OK, 1 = problem diameter, 2 = problem with depth
ValidToolPath = 0

' Initialise array to contain lines of gcode
Dim GCode(10000) As String ' max 10000 lines of gcode
Dim Code_String As String

' Reset counter used for array index to store each line of gcode created
Line_Counter = 0

' Set pocket step over % (used if full pocket option selected).  Expects and integer value up to 100%.
'PocketStepOverPercent = 30

'''' END OF GCODE INITIALISATION************************************************************************************

'''' MAIN CONTROL SECTION ******************************************************************************************
    ' set up for either a inside circle contour, or a inside circle pocket
    Select Case Read_CircleType
        Case -1 ' *************** inside circle **
            ' Calculate start point of circle and toolpath radius
            Tool_Xstart = Read_HoleX + (Read_CircleDia / 2) - (Read_ToolDia / 2) - Read_RadialStockToLeave
            Tool_Ystart = Read_HoleY
            Tool_Zstart = Read_HoleZ + Start_Offset_Z
            Tool_PathRadius = ((Read_CircleDia / 2) - (Read_ToolDia / 2)) - Read_RadialStockToLeave
                    
            '''' ERROR CHECKS
            ' Set Warning Font to RED
            Warning.ForeColor = 255
            
            ' Check if toolpath radius is very small
            If Tool_PathRadius < 0.1 Then
                Warning.Value = "WARNING: Tool path radius very small.  Code has posted, but please check parameters above"
                ValidToolPath = 0 ' 0 = code is assumed to be valid but show warning
            End If
            
             ' Check if toolpath radius is extremely small
            If Tool_PathRadius < 0.001 Then
                Warning.Value = "WARNING: Tool path radius too small.  Please check parameters."
                ValidToolPath = 1 '
            End If
            
            ' Check if step down value greater than hole depth
            If Read_StepDown > Read_CircleDepth Then
                Warning.Value = "WARNING: Step down is > circle depth, maximum depth is set to circle depth"
                ValidToolPath = 1
            End If
            
            ' Check if hole depth is negative value
            If Read_CircleDepth < 0 Then
                Warning.Value = "WARNING: Hole depth value must be positive"
                ValidToolPath = 1
            End If
                        
            ' Check if tool can fit inside circle including radial stock to leave
            If Tool_PathRadius + (Read_ToolDia / 2) > (Read_CircleDia / 2) Or Tool_PathRadius < 0 Then
                Warning.Value = "WARNING: Tool does not fit inside circle.  Select smaller tool or enter smaller radial stock to leave."
                ValidToolPath = 1
            End If
            
            ' Check if step down is negative - it will get stuck in an endless loop
            If Read_StepDown <= 0 Then
                Warning.Value = "WARNING: Step down must be positive and greater than zero."
                ValidToolPath = 1
            End If
            
            ' Check if tool diameter is negative
            If Read_ToolDia <= 0 Then
                Warning.Value = "WARNING: Tool diameter must be positive and greater than zero."
                ValidToolPath = 1
            End If
            
            '''' END OF ERROR CHECKS
            
            '''' check if tool path is valid (=0), and if so calculate tool path, post the code, and save the .txt file
            If ValidToolPath = 0 Then
                ' Add header text in gcode file, for user information
                Code_String = "(INSIDE CONTOUR)": Call AddCode(GCode(), Code_String, Line_Counter)
                Code_String = "(Tool diameter: " & ToolDia & ")": Call AddCode(GCode(), Code_String, Line_Counter)
                Code_String = "(Circle diameter: " & CircleDia & ")": Call AddCode(GCode(), Code_String, Line_Counter)
                Code_String = "(Circle depth: " & CircleDepth & ")": Call AddCode(GCode(), Code_String, Line_Counter)
                Code_String = " ": Call AddCode(GCode(), Code_String, Line_Counter)
                
                ' Switch on spindle M03 with speed set by user Sxxxxx rpm
                Code_String = "(Switch on spindle at " & SpindleSpeed & " rpm)": Call AddCode(GCode(), Code_String, Line_Counter)
                Code_String = "S" & SpindleSpeed & " M03": Call AddCode(GCode(), Code_String, Line_Counter)
                
                ' Header text to show moving to start of first cut
                Code_String = "(Move to start of first cut)": Call AddCode(GCode(), Code_String, Line_Counter)
                
                ' Create tool XYZ start position code
                Code_String = "G1 X" & Tool_Xstart & " Y" & Tool_Ystart & " Z" & Tool_Zstart & " F" & Read_FeedPlunge: Call AddCode(GCode(), Code_String, Line_Counter)
                
                ' Tool is now at start Z so set current Z position to Z starting position
                Tool_Zcurrent = Tool_Zstart
                                
                ' For a simple inside contour set tool X start point to tool path radius, and run spiral down subroutine
                Tool_Xstart = Tool_PathRadius
                Call CutSpiral(GCode(), Code_String, Line_Counter, Tool_Xstart, Tool_Ystart, Tool_Zstart, Read_HoleZ, Tool_PathRadius, Read_CircleDepth, Read_StepDown, Read_FeedCutting)
                
            Else
                ' not a valid toolpath, so clear gcode array and clear gcode file
                Erase GCode()
                ' Display in form to remove contents
                Me.Gcode_Commands.List = GCode()
                ' Save Gcode to file to clear file contents
                Call Write_Text_File(GCode(), Read_My_Path_Name, Read_My_File_Name)
                ' Leave the subrouting
                Exit Sub
            End If
        
        Case 0 ' *************** full inside pocket ***************************************************************
           ' Calculate END point of circle, the final outermost roughing diameter
           Tool_Xend = Read_HoleX + (Read_CircleDia / 2) - (Read_ToolDia / 2) - Read_RadialStockToLeave
           
           ' Set up tool starting coordinates
           Tool_Xstart = Read_HoleX
           Tool_Ystart = Read_HoleY
           Tool_Zstart = Read_HoleZ + Start_Offset_Z
           
           ' Calculate pocket step over (30% of tool dia)
           PocketStepOver = ToolDia * PocketStepOverPercent / 100
           
           ' Reset flag to monitor if final radius has been reached
           Reached_RoughingRadius = False
           
           '''' ERROR CHECKS
           ' Set Warning Font to RED
           Warning.ForeColor = 255
           
           ' Check if hole depth is negative value
            If Read_CircleDepth < 0 Then
                Warning.Value = "WARNING: Hole depth value must be positive"
                ValidToolPath = 1
            End If
           
           ' check if pocket step over is too large for roughing diameter of pocket
           If PocketStepOver >= (Tool_Xend - Read_HoleX) Then
                Warning.Value = "WARNING: Pocket step over is too large considering tool diameter and hole diameter"
                ValidToolPath = 1
           End If
           
            ' Check if step down is negative - it will get stuck in an endless loop
            If Read_StepDown <= 0 Then
                Warning.Value = "WARNING: Step down must be positive and greater than zero."
                ValidToolPath = 1
            End If
                     
            ' Check if step down value greater than hole depth
            If Read_StepDown > Read_CircleDepth Then
                Warning.Value = "WARNING: Step down is > circle depth, please modify step down value"
                ValidToolPath = 1
            End If
                        
            ' Check if tool can fit inside circle including radial stock to leave
            If (Read_ToolDia / 2) + Read_RadialStockToLeave >= (Read_CircleDia / 2) Then
                Warning.Value = "WARNING: Tool does not fit inside circle.  Select smaller tool or enter smaller radial stock to leave."
                ValidToolPath = 1
            End If

            ' Check if tool diameter is negative
            If Read_ToolDia <= 0 Then
                Warning.Value = "WARNING: Tool diameter must be positive and greater than zero."
                ValidToolPath = 1
            End If
        
            ' Check if pocket step over is zero or nagative
            If Read_PocketStepOverPercent <= 0 Then
                Warning.Value = "WARNING: Pocket step over must be positive and greater than zero."
                ValidToolPath = 1
            End If
        
        
           '''' END OF ERROR CHECKS
                            
                  
           '''' check if tool path is valid (=0), and if so calculate tool path, post the code, and save the .txt file
           If ValidToolPath = 0 Then
                ' Add header text in gcode file, for user information
                Code_String = "(INSIDE POCKET)": Call AddCode(GCode(), Code_String, Line_Counter)
                Code_String = "(Tool diameter: " & ToolDia & ")": Call AddCode(GCode(), Code_String, Line_Counter)
                Code_String = "(Overall circle diameter: " & CircleDia & ")": Call AddCode(GCode(), Code_String, Line_Counter)
                Code_String = "(Overall circle depth: " & CircleDepth & ")": Call AddCode(GCode(), Code_String, Line_Counter)
                Code_String = "(Pocket Stepover: " & PocketStepOverPercent & "%)": Call AddCode(GCode(), Code_String, Line_Counter)
                Code_String = " ": Call AddCode(GCode(), Code_String, Line_Counter)
                
                ' Switch on spindle M03 with speed set by user Sxxxxx rpm
                Code_String = "(Switch on spindle at " & SpindleSpeed & " rpm)": Call AddCode(GCode(), Code_String, Line_Counter)
                Code_String = "S" & SpindleSpeed & " M03": Call AddCode(GCode(), Code_String, Line_Counter)
                
                ' Header text to show moving to start of first cut
                Code_String = "(Move to start of first cut)": Call AddCode(GCode(), Code_String, Line_Counter)
                
                '''' Create tool XYZ start position code for first circle "canned cycle"
                Tool_Xstart = Tool_Xstart + (ToolDia * PocketStepOverPercent / 100)
                ' Check if tool would step over outside roughing diameter, and if so then set to max roughing diameter
                If Tool_Xstart > Tool_Xend Then
                    ' Bring tool back to max allow radius
                    Tool_Xstart = Tool_Xend
                    ' Cancel any canned cycles
                    Reached_RoughingRadius = True
                End If
                ' Write start position GCode
                Code_String = "G1 X" & Tool_Xstart & " Y" & Tool_Ystart & " Z" & Tool_Zstart & " F" & Read_FeedPlunge: Call AddCode(GCode(), Code_String, Line_Counter)
                                
                ' Set tool radius
                Tool_PathRadius = Tool_Xstart - Read_HoleX
                                
                '''' Loop around "canned cycle", stepping out tool by tool overlap each time until hit final roughing diameter
                While Reached_RoughingRadius = False
                    ' Create gcode for spiral cut down to full depth
                    Call CutSpiral(GCode(), Code_String, Line_Counter, Tool_Xstart, Tool_Ystart, Tool_Zstart, Read_HoleZ, Tool_PathRadius, Read_CircleDepth, Read_StepDown, Read_FeedCutting)
                    
                    ' Raise tool to safe height out of pocket
                    Code_String = "G0 Z" & Tool_Zstart: Call AddCode(GCode(), Code_String, Line_Counter)
                                         
                    ' Increment tool cutting radius to move out to next circle
                    Tool_Xstart = Tool_Xstart + (ToolDia * PocketStepOverPercent / 100)  ' increment by step over for each circle "canned cycle"
                    ' Create next toolpath radius for "canned cycle"
                    Tool_PathRadius = Tool_Xstart - Read_HoleX
                    'Tool_PathRadius = Tool_Xstart
                  
                    ' check if tool position is outside roughing diameter, if so set to roughing diameter and make final cycle
                    If Tool_Xstart >= Tool_Xend Then
                       ' set flag for end of all roughing
                       Reached_RoughingRadius = True
                       ' set tool position to final roughing radius
                       Tool_Xstart = Tool_Xend
                       ' adjust radius to suit
                       Tool_PathRadius = Tool_Xstart - Read_HoleX
                       ' Add code to move cutter out to last spiral "canned cycle"
                       Code_String = "G1 X" & Tool_Xstart & " Y" & Tool_Ystart & " Z" & Tool_Zstart & " F" & Read_FeedPlunge: Call AddCode(GCode(), Code_String, Line_Counter)
                       ' Create gcode for spiral cut down to full depth for final roughing
                       Call CutSpiral(GCode(), Code_String, Line_Counter, Tool_Xstart, Tool_Ystart, Tool_Zstart, Read_HoleZ, Tool_PathRadius, Read_CircleDepth, Read_StepDown, Read_FeedCutting)
                    Else
                       ' Not finished yet so add code to move cutter out to next spiral "canned cycle"
                       Code_String = "G1 X" & Tool_Xstart & " Y" & Tool_Ystart & " Z" & Tool_Zstart & " F" & Read_FeedPlunge: Call AddCode(GCode(), Code_String, Line_Counter)
                    End If
                Wend
                
            Else
                ' not a valid toolpath, so clear gcode array and clear gcode file
                Erase GCode()
                ' Display in form to remove contents
                Me.Gcode_Commands.List = GCode()
                ' Save Gcode to file to clear file contents
                Call Write_Text_File(GCode(), Read_My_Path_Name, Read_My_File_Name)
                ' Leave the subrouting
                Exit Sub
           End If
        
    End Select

    ' Check if "include full depth finish pass" is selected
    If Read_IncludeFinishPass = True Then
        ' Calculate bottom of hole, to avoid overshooting if step down is not an integer of depth
        Circle_Bottom = Read_HoleZ - Read_CircleDepth
        
        ' plunge to bottom of hole (at plunge feedrate) but away from finish cut
        Code_String = "(Pocket Rough complete, starting finish pass)": Call AddCode(GCode(), Code_String, Line_Counter)
        'Code_String = "G1 X" & Tool_Xstart & " Y" & Tool_Ystart & " Z" & Circle_Bottom & " F" & Read_FeedPlunge: Call AddCode(GCode(), Code_String, Line_Counter)
        
        ' move out to finish radius (at 1/3 cutting feedrate), then cut full circle
        InitialFinishCutting = Read_FeedCutting / 3
        Code_String = "G1 X" & Tool_Xstart + Read_RadialStockToLeave & " Y" & Tool_Ystart & " Z" & Circle_Bottom & " F" & InitialFinishCutting: Call AddCode(GCode(), Code_String, Line_Counter)
        Code_String = "G2 I-" & Tool_PathRadius + Read_RadialStockToLeave & " Z" & Circle_Bottom & " F" & Read_FeedCutting: Call AddCode(GCode(), Code_String, Line_Counter)
        
        ' End of of finish cycle so lift tool to top of circle
        Code_String = "(Finish complete, rapid lift tool to top of circle)": Call AddCode(GCode(), Code_String, Line_Counter)
        Code_String = "G0 Z" & Tool_Zstart: Call AddCode(GCode(), Code_String, Line_Counter)
        
        Else
        ' if finish pass not required then lift tool to top of circle and finish code
        Code_String = "(Rough complete, rapid lift tool to top of circle)": Call AddCode(GCode(), Code_String, Line_Counter)
        Code_String = "G0 Z" & Tool_Zstart: Call AddCode(GCode(), Code_String, Line_Counter)
        
    End If
    
    '''' Add outro section to gcode, switch off spindle, rewind file and save to gcode to text file
    ' Switchoff spindle M05
    Code_String = "M05": Call AddCode(GCode(), Code_String, Line_Counter)
    
    ' Rewind file M30
    Code_String = "M30": Call AddCode(GCode(), Code_String, Line_Counter)
        
    ' Display lines of code used (out of max 5000)
    Code_String = "(Used " & Line_Counter + 1 & " lines out of maximum 10000)": Call AddCode(GCode(), Code_String, Line_Counter)
        
    '''' Create Gcode list
    Me.Gcode_Commands.List = GCode()
    
    '''' Save Gcode to file
    ' check if folder and file name have been user selected
    If Read_My_Path_Name = "" Or Read_My_File_Name = "" Then
            Warning.Value = "WARNING: GCode file could not be saved, please check folder and file name have been entered below."
    Else
        ' if folder and file name have been entered then change font to gree and display message
        Warning.ForeColor = 49152
        Warning.Value = "GCode File Saved"
        ' Then save gcode into .txt file
        Call Write_Text_File(GCode(), Read_My_Path_Name, Read_My_File_Name)
    End If

End Sub
Private Sub CutSpiral(GCode() As String, Code_String As String, Line_Counter As Integer, Tool_Xstart As Double, Tool_Ystart As Double, Tool_Zstart As Double, Read_HoleZ As Double, Tool_PathRadius As Double, Read_CircleDepth As Double, Read_StepDown As Double, Read_FeedCutting)
' subroutine to cut a simple spiral using parameters passed

'''' GCODE CREATION SECTION **************************************************************
    ' set tool start to current position
    Tool_Zcurrent = Tool_Zstart
    
    ' flag if reached bottom of hole
    Dim Reached_Hole_Bottom As Boolean
    Reached_Hole_Bottom = False
    
    ' Check values are not exponents e.g. 4.9999e02, force format to proper number e.g. 0.049999
    If Tool_Xstart <> 0 Then Tool_Xstart = Format(Tool_Xstart, "#.######")
    If Tool_Ystart <> 0 Then Tool_Ystart = Format(Tool_Ystart, "#.######")
    If Tool_Zstart <> 0 Then Tool_Zstart = Format(Tool_Zstart, "#.######")
    If Tool_PathRadius <> 0 Then Tool_PathRadius = Format(Tool_PathRadius, "#.######")
    If Tool_Zcurrent <> 0 Then Tool_Zcurrent = Format(Tool_Zcurrent, "#.######")
     
    ' Calculate bottom of hole, to avoid overshooting if step down is not an integer of depth
    Circle_Bottom = Read_HoleZ - Read_CircleDepth
    
    'Create circle cutting loops to build main code
    Code_String = "(Spiral cutting cycles)": Call AddCode(GCode(), Code_String, Line_Counter)
      
    ' Loop through creating spirals until bottom of hole reached
    While Reached_Hole_Bottom = False
    
        ' Advance tool next step down
        Tool_Zcurrent = Tool_Zcurrent - Read_StepDown
        
        ' check if on or above hole bottom and add next spiral cut
        If Tool_Zcurrent > Circle_Bottom Then
            ' Create circle code to cut next spiral
            Code_String = "G2 I-" & Tool_PathRadius & " Z" & Tool_Zcurrent & " F" & Read_FeedCutting: Call AddCode(GCode(), Code_String, Line_Counter)
        End If
                        
        ' check if overshot bottom of hole (if step down is not an integer of the hole depth)
        If Tool_Zcurrent <= Circle_Bottom Then
            ' set tool to maximum depth of hole
            Tool_Zcurrent = Circle_Bottom
            ' set flag for reached bottom of hole
            Reached_Hole_Bottom = True
            ' cut 2 more circle to ensure hole is clean
            Code_String = "G2 I-" & Tool_PathRadius & " Z" & Tool_Zcurrent & " F" & Read_FeedCutting: Call AddCode(GCode(), Code_String, Line_Counter)
            Code_String = "G2 I-" & Tool_PathRadius & " Z" & Tool_Zcurrent & " F" & Read_FeedCutting: Call AddCode(GCode(), Code_String, Line_Counter)
        End If
        
    Wend
    
End Sub
Private Sub AddCode(GCode() As String, Code_String As String, Line_Counter As Integer)

' add code to line
GCode(Line_Counter) = Code_String

' increment code line index
Line_Counter = Line_Counter + 1


End Sub

Private Sub Write_Text_File(GCode() As String, Read_My_Path_Name As String, Read_My_File_Name As String)

'Create object for file system
Dim fsobj As Object
Set fsobj = CreateObject("Scripting.FileSystemObject")

' setup path and file name
strPath = Read_My_Path_Name
strFileName = Read_My_File_Name
FileTypeAppend = ".txt"

'Create text file object
Dim txtFile As Object
Set txtFile = fsobj.CreateTextFile(strPath & strFileName & FileTypeAppend)

'populate text file
    For n = 0 To UBound(GCode)
        'write one gcode line from the array into the .txt file
        txtFile.WriteLine GCode(n)
    Next
    ' close file
    txtFile.Close

'set objects to nothing
Set fsobj = Nothing
Set txtFile = Nothing

End Sub

Private Sub My_Browse_Folder_Click()
' Show user folder path to allow selection of path, then store in form box

' variables
Dim FldrPicker As FileDialog
Dim myFolder As String

'User folder to save into using Dialog Box
  Set FldrPicker = Application.FileDialog(msoFileDialogFolderPicker)

  With FldrPicker
    .Title = "Select A Target Folder"
    .AllowMultiSelect = False
    If .Show <> -1 Then Exit Sub 'Check if user clicked cancel button
    myFolder = .SelectedItems(1) & "\"
  End With
  
'Store folder path in form window box
My_Path_Name.Value = myFolder
End Sub
