/*
 * Decompiled with CFR 0.152.
 */
package cncprobe;

import cncprobe.SimplePoint3D;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PCBProbe
extends JFrame {
    private JFileChooser _fc = new JFileChooser();
    private Pattern _floatPt = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+");
    private SimplePoint3D _lowest;
    private SimplePoint3D _highest;
    private int _pointCount;
    private DecimalFormat _fourDP = new DecimalFormat("#.####");
    private JTextField _xstart = new JTextField(5);
    private JTextField _ystart = new JTextField(5);
    private JTextField _millWidth = new JTextField(5);
    private JTextField _millHeight = new JTextField(5);
    private JTextField _probeFeed = new JTextField(5);
    private JTextField _probeDepth = new JTextField(5);
    private JTextField _probeClearance = new JTextField(5);
    private JTextField _dPSpacing = new JTextField(5);
    private JTextField _finishHeight = new JTextField(5);
    private JTextField _inset = new JTextField(5);
    private JButton _generateBtn = new JButton("Generate GCode File");
    private JButton _resetBtn = new JButton("Reset Values");
    private JComboBox _units = new JComboBox<String>(new String[]{"Millimeters", "Inches"});
    private JTextField _pointCountTxt = new JTextField(3);
    private JTextField _lowestXTxt = new JTextField(5);
    private JTextField _lowestYTxt = new JTextField(5);
    private JTextField _lowestZTxt = new JTextField(5);
    private JTextField _highestXTxt = new JTextField(5);
    private JTextField _highestYTxt = new JTextField(5);
    private JTextField _highestZTxt = new JTextField(5);
    private JTextField _differenceTxt = new JTextField(5);

    public static void main(String[] args) {
        PCBProbe PCBProbe2 = new PCBProbe();
        PCBProbe2.init();
    }

    public void init() {
        this.setTitle("CNCProbe");
        this.setDefaultCloseOperation(3);
        JPanel filePanel = new JPanel();
        filePanel.setBorder(BorderFactory.createTitledBorder("GCode file generation"));
        filePanel.setLayout(new BoxLayout(filePanel, 1));
        this.layoutFilePanel(filePanel);
        this.resetVariables();
        JPanel logPanel = new JPanel();
        logPanel.setBorder(BorderFactory.createTitledBorder("Probe stats"));
        logPanel.setLayout(new BoxLayout(logPanel, 3));
        this.layoutLogPanel(logPanel);
        this.add((Component)logPanel, "Center");
        this.add((Component)filePanel, "West");
        this.pack();
        this.setVisible(true);
    }

    private void layoutFilePanel(JPanel filePanel) {
        filePanel.add(this._units);
        this._units.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PCBProbe.this.resetVariables();
            }
        });
        JPanel variablePnl = new JPanel();
        variablePnl.setLayout(new GridLayout(10, 2));
        JPanel xStartPnl = new JPanel(new FlowLayout(0));
        variablePnl.add(new JLabel("X", 4));
        xStartPnl.add(this._xstart);
        variablePnl.add(xStartPnl);
        JPanel yStartPnl = new JPanel(new FlowLayout(0));
        variablePnl.add(new JLabel("Y", 4));
        yStartPnl.add(this._ystart);
        variablePnl.add(yStartPnl);
        JPanel widthPnl = new JPanel(new FlowLayout(0));
        variablePnl.add(new JLabel("X Length", 4));
        widthPnl.add(this._millWidth);
        variablePnl.add(widthPnl);
        JPanel heightPnl = new JPanel(new FlowLayout(0));
        variablePnl.add(new JLabel("Y Length", 4));
        heightPnl.add(this._millHeight);
        variablePnl.add(heightPnl);
        JPanel feedPnl = new JPanel(new FlowLayout(0));
        variablePnl.add(new JLabel("Z Feed", 4));
        feedPnl.add(this._probeFeed);
        feedPnl.add(new JLabel(" units per minute"));
        variablePnl.add(feedPnl);
        JPanel probeDepth = new JPanel(new FlowLayout(0));
        variablePnl.add(new JLabel("Probe Depth", 4));
        probeDepth.add(this._probeDepth);
        variablePnl.add(probeDepth);
        JPanel probeHeight = new JPanel(new FlowLayout(0));
        variablePnl.add(new JLabel("Probe Movement Height", 4));
        probeHeight.add(this._probeClearance);
        variablePnl.add(probeHeight);
        JPanel spacing = new JPanel(new FlowLayout(0));
        variablePnl.add(new JLabel("Probe Spacing", 4));
        spacing.add(this._dPSpacing);
        variablePnl.add(spacing);
        JPanel finishHeight = new JPanel(new FlowLayout(0));
        variablePnl.add(new JLabel("Z Safe Height", 4));
        finishHeight.add(this._finishHeight);
        variablePnl.add(finishHeight);
        JPanel insetPnl = new JPanel(new FlowLayout(0));
        variablePnl.add(new JLabel("Edge Inset", 4));
        insetPnl.add(this._inset);
        variablePnl.add(insetPnl);
        filePanel.add(variablePnl);
        filePanel.add(this._generateBtn);
        this._generateBtn.setAlignmentX(0.5f);
        this._generateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PCBProbe.this._fc.setSelectedFile(new File("PCBProbe.ngc"));
                if (PCBProbe.this._fc.showSaveDialog(null) == 0) {
                    PCBProbe.this.writeFile(PCBProbe.this._fc.getSelectedFile());
                }
            }
        });
        filePanel.add(this._resetBtn);
        this._resetBtn.setAlignmentX(0.5f);
        this._resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PCBProbe.this.resetVariables();
            }
        });
    }

    private void layoutLogPanel(JPanel logPanel) {
        JPanel pointsPnl = new JPanel();
        pointsPnl.add(new JLabel("Total probe points"));
        pointsPnl.add(this._pointCountTxt);
        this._pointCountTxt.setEditable(false);
        JPanel lowestPnl = new JPanel();
        lowestPnl.add(new JLabel("Lowest point (X, Y, Z)"));
        lowestPnl.add(this._lowestXTxt);
        this._lowestXTxt.setEditable(false);
        lowestPnl.add(this._lowestYTxt);
        this._lowestYTxt.setEditable(false);
        lowestPnl.add(this._lowestZTxt);
        this._lowestZTxt.setEditable(false);
        JPanel highestPnl = new JPanel();
        highestPnl.add(new JLabel("Highest point (X, Y, Z)"));
        highestPnl.add(this._highestXTxt);
        this._highestXTxt.setEditable(false);
        highestPnl.add(this._highestYTxt);
        this._highestYTxt.setEditable(false);
        highestPnl.add(this._highestZTxt);
        this._highestZTxt.setEditable(false);
        JPanel diffPnl = new JPanel();
        diffPnl.add(new JLabel("Difference"));
        diffPnl.add(this._differenceTxt);
        this._differenceTxt.setEditable(false);
        logPanel.add(pointsPnl);
        logPanel.add(lowestPnl);
        logPanel.add(highestPnl);
        logPanel.add(diffPnl);
        JButton loadLogBtn = new JButton("Load Log");
        logPanel.add(loadLogBtn);
        loadLogBtn.setAlignmentX(0.5f);
        loadLogBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PCBProbe.this._fc.setSelectedFile(new File("levelprobe.log"));
                if (PCBProbe.this._fc.showOpenDialog(null) == 0) {
                    PCBProbe.this.readLog(PCBProbe.this._fc.getSelectedFile());
                    PCBProbe.this._pointCountTxt.setText("" + PCBProbe.this._pointCount);
                    PCBProbe.this._lowestXTxt.setText(PCBProbe.this._fourDP.format(PCBProbe.this._lowest.getX()));
                    PCBProbe.this._lowestYTxt.setText(PCBProbe.this._fourDP.format(PCBProbe.this._lowest.getY()));
                    PCBProbe.this._lowestZTxt.setText(PCBProbe.this._fourDP.format(PCBProbe.this._lowest.getZ()));
                    PCBProbe.this._highestXTxt.setText(PCBProbe.this._fourDP.format(PCBProbe.this._highest.getX()));
                    PCBProbe.this._highestYTxt.setText(PCBProbe.this._fourDP.format(PCBProbe.this._highest.getY()));
                    PCBProbe.this._highestZTxt.setText(PCBProbe.this._fourDP.format(PCBProbe.this._highest.getZ()));
                    PCBProbe.this._differenceTxt.setText(PCBProbe.this._fourDP.format(PCBProbe.this._highest.getZ() - PCBProbe.this._lowest.getZ()));
                }
            }
        });
    }

    private void resetVariables() {
        if (this._units.getSelectedIndex() == 0) {
            this._xstart.setText("0");
            this._ystart.setText("0");
            this._millWidth.setText("70");
            this._millHeight.setText("50");
            this._probeFeed.setText("200");
            this._probeDepth.setText("-1");
            this._probeClearance.setText("2");
            this._dPSpacing.setText("5");
            this._finishHeight.setText("20");
            this._inset.setText("2");
        } else {
            this._xstart.setText("0");
            this._ystart.setText("0");
            this._millWidth.setText("3");
            this._millHeight.setText("2");
            this._probeFeed.setText("10");
            this._probeDepth.setText("0.0625");
            this._probeClearance.setText("0.125");
            this._dPSpacing.setText("0.25");
            this._finishHeight.setText("1");
            this._inset.setText("0.0625");
        }
    }

    private void readLog(File logFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(logFile));){
            String line;
            String firstPoint;
            while ((firstPoint = this.isPoint(br.readLine())) == null) {
            }
            this._lowest = new SimplePoint3D(this.getXInString(firstPoint), this.getYInString(firstPoint), this.getZInString(firstPoint));
            this._highest = new SimplePoint3D(this.getXInString(firstPoint), this.getYInString(firstPoint), this.getZInString(firstPoint));
            this._pointCount = 1;
            while ((line = this.isPoint(br.readLine())) != null) {
                ++this._pointCount;
                if (this.getZInString(line) < this._lowest.getZ()) {
                    this._lowest = new SimplePoint3D(this.getXInString(line), this.getYInString(line), this.getZInString(line));
                }
                if (!(this.getZInString(line) > this._highest.getZ())) continue;
                this._highest = new SimplePoint3D(this.getXInString(line), this.getYInString(line), this.getZInString(line));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String isPoint(String line) {
        if (line == null) {
            return null;
        }
        if (this.getZInString(line) != Double.NaN && this.getYInString(line) != Double.NaN && this.getXInString(line) != Double.NaN) {
            return line;
        }
        return null;
    }

    private void writeFile(File file) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            this.writeLine(bw, "(This GCode file probes an area and logs the coordinates of each probe)");
            this.writeLine(bw, "(The variables #1 to #10 can be changed within the software that generates this file)");
            this.writeLine(bw, "(or they can be changed directly within this file)");
            this.writeLine(bw, "(all other code should be left unchanged)");
            bw.newLine();
            this.writeLine(bw, "(prerequisites)");
            this.writeLine(bw, "(1. need a working probe)");
            if (this._units.getSelectedIndex() == 0) {
                this.writeLine(bw, "(2. tool needs to be within 10mm of copper board for the 1st probe, )");
                this.writeLine(bw, "(i.e. Z0.000 should be no more than 10mm above the board initially)");
            } else {
                this.writeLine(bw, "(2. tool needs to be within 3/8\" of copper board for the 1st probe, )");
                this.writeLine(bw, "(i.e. Z0.000 should be no more than 3/8\" above the board initially)");
            }
            this.writeLine(bw, "(Note: The first probe will touch off Z to 0.000 when it first touches to copper, )");
            this.writeLine(bw, "(all other probe values are relative to this first point)");
            bw.newLine();
            this.writeLine(bw, "#1=" + this._xstart.getText() + " (X start)");
            this.writeLine(bw, "#2=" + this._ystart.getText() + " (Y start)");
            this.writeLine(bw, "#3=" + this._millWidth.getText() + " (X size)");
            this.writeLine(bw, "#4=" + this._millHeight.getText() + " (Y size)");
            this.writeLine(bw, "#5=" + this._probeFeed.getText() + " (probe feed rate)");
            this.writeLine(bw, "#6=" + this._probeDepth.getText() + " (probe depth)");
            this.writeLine(bw, "#7=" + this._dPSpacing.getText() + " (probe spacing)");
            this.writeLine(bw, "#8=" + this._finishHeight.getText() + " (Z finish height)");
            this.writeLine(bw, "#9=" + this._probeClearance.getText() + " (probe clearence height)");
            this.writeLine(bw, "#10=" + this._inset.getText() + " (INSET, space from edges)");
            bw.newLine();
            this.writeLine(bw, "(calculated values, do not change)");
            this.writeLine(bw, "#11=[#3 - [2 * #10]] (X size - inset)");
            this.writeLine(bw, "#12=[#4 - [2 * #10]] (Y size - inset)");
            this.writeLine(bw, "#13=[#11 / #7] (X probe count)");
            this.writeLine(bw, "#14=[#11 / FIX[#13]] (X spacing)");
            this.writeLine(bw, "#15=[#12 / #7] (Y probe count)");
            this.writeLine(bw, "#16=[#12 / FIX[#15]] (Y spacing)");
            bw.newLine();
            if (this._units.getSelectedIndex() == 0) {
                this.writeLine(bw, "G21 (millimeters)");
            } else {
                this.writeLine(bw, "G20 (Inches)");
            }
            this.writeLine(bw, "G90 (absolute distance mode, not incremental)");
            bw.newLine();
            this.writeLine(bw, "(LOGOPEN, levelprobe.log)");
            this.writeLine(bw, "(begin initial probe and set Z to 0)");
            this.writeLine(bw, "G0 X#1 Y#2 Z0");
            this.writeLine(bw, "G0 X[#1 + #10] Y[#2 + #10]");
            if (this._units.getSelectedIndex() == 0) {
                this.writeLine(bw, "G38.2 Z-10 F#5");
            } else {
                this.writeLine(bw, "G38.2 Z-0.375 F#5");
            }
            this.writeLine(bw, "G10 L20 P0 Z0");
            this.writeLine(bw, "O1 while [#5421 le #12]");
            this.writeLine(bw, "     G0 Z#9");
            this.writeLine(bw, "     G0 X[#1 + #10]");
            this.writeLine(bw, "     G38.2 Z#6 F#5");
            this.writeLine(bw, "     (LOG, X#5420 Y#5421 Z#5422)");
            this.writeLine(bw, "     O2 while [[#5420 + #14] le #11]");
            this.writeLine(bw, "         G0 Z#9");
            this.writeLine(bw, "         G0 X[#5420 + #14]");
            this.writeLine(bw, "         G38.2 Z#6 F#5");
            this.writeLine(bw, "         (LOG, X#5420 Y#5421 Z#5422)");
            this.writeLine(bw, "     O2 endwhile");
            this.writeLine(bw, "     G0 Z#9");
            this.writeLine(bw, "     G0 Y[#5421 + #16]");
            this.writeLine(bw, "O1 endwhile");
            this.writeLine(bw, "(LOGCLOSE)");
            this.writeLine(bw, "G0 Z#9");
            this.writeLine(bw, "G0 X#1 Y#2 Z#8");
            this.writeLine(bw, "M2");
            this.writeLine(bw, "%");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
        }
    }

    private void writeLine(BufferedWriter bw, String line) throws IOException {
        bw.write(line);
        bw.newLine();
    }

    public double getXInString(String xString) {
        return this.getCharInString(xString, 'X');
    }

    public double getYInString(String yString) {
        return this.getCharInString(yString, 'Y');
    }

    public double getZInString(String zString) {
        return this.getCharInString(zString, 'Z');
    }

    private double getCharInString(String xString, char charToFind) {
        String upperString = xString.toUpperCase();
        Matcher floatMatcher = this._floatPt.matcher(upperString);
        while (floatMatcher.find()) {
            if (upperString.charAt(floatMatcher.start() - 1) != charToFind) continue;
            String subString = upperString.substring(floatMatcher.start(), floatMatcher.end());
            return Double.parseDouble(subString);
        }
        return Double.NaN;
    }
}

